/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.api;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.api.HttpService;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.worker.ThreadContext;

public class DynamicExecutor
extends HttpServlet {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(DynamicExecutor.class);
    private static final Logger logger = LogManager.getLogger();
    private final String className;
    private Setup setup;
    private HttpService httpService;

    public DynamicExecutor(String className) {
        this.className = className;
    }

    public void init() throws ServletException {
        try {
            logger.info("Init " + this.className);
            this.setup = Setup.getSetup();
            this.httpService = DynamicClassManager.getInstance().newProxyInstance(HttpService.class, this.className);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.serviceImpl(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceImpl(HttpServletRequest request, HttpServletResponse response) {
        ServerContext ctx = new ServerContext(this.setup, 0, 0);
        ThreadContext parent = ThreadContext.push((ThreadContext)ctx);
        try {
            this.httpService.service(request, response);
        }
        finally {
            ThreadContext.pop((ThreadContext)ctx, (ThreadContext)parent);
        }
    }
}

