/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class DynamicTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private static final Logger logger = LogManager.getLogger();
    private static final Class<?>[] types = new Class[]{Integer.TYPE, ParameterMap.class};
    private final String className;
    private final TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> node;

    public DynamicTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.className = parameterMap.get("className", "");
        TariffTreeNode node = null;
        try {
            if (Utils.notBlankString((String)this.className)) {
                node = DynamicClassManager.getInstance().newInstance(TariffTreeNode.class, this.className, types, new Object[]{id, parameterMap});
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.node = node;
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (this.node != null) {
            return this.node.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext);
        }
        return 0;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        throw new UnsupportedOperationException();
    }
}

