/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.action;

import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.server.action.base.ActionBase;
import ru.bitel.bgbilling.kernel.integration.server.bean.Register;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterManager;
import ru.bitel.common.TimeUtils;

public class ActionRegisterItemTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int registerId = this.getIntParameter("register_id", -1);
        if (registerId < 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        RegisterManager rm = new RegisterManager(this.con);
        RegisterItemManager prim = new RegisterItemManager(this.con);
        Directory<PaymentType> paymentTDirectory = this.context.getDirectory(PaymentType.class, 0);
        Directory<ChargeType> chargeTDirectory = this.context.getDirectory(ChargeType.class, 0);
        Register register = rm.getRegisterById(registerId);
        if (register == null) {
            throw new BGMessageException("\u0420\u0435\u0435\u0441\u0442\u0440 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        Element row = null;
        Contract contract = null;
        for (RegisterItem item : prim.getRegisterItems(register)) {
            row = this.createElement(data, "row");
            ContractDao contractDao = new ContractDao(this.con, this.userId);
            contract = (Contract)contractDao.get(item.getContractId());
            contractDao.close();
            if (contract != null) {
                row.setAttribute("contract", contract.getTitle() + " (" + contract.getComment() + ")");
            }
            row.setAttribute("id", String.valueOf(item.getBalanceItemId()));
            if (register.getRegisterType() == 1) {
                row.setAttribute("charge_id", String.valueOf((Object)chargeTDirectory.get(item.getBalanceItemTypeId())));
            } else {
                row.setAttribute("payment_id", String.valueOf(paymentTDirectory.get(item.getBalanceItemTypeId()).getTitle()));
            }
            row.setAttribute("summa", item.getSumma().toPlainString());
            row.setAttribute("comment", item.getBalanceItemComment());
            row.setAttribute("date", TimeUtils.formatDate((Date)item.getDate()));
        }
        Element loadLog = this.createElement(this.rootNode, "load_log");
        if (register.getLoadLog() != null) {
            String log = register.getLoadLog().replaceAll("[^\\P{Cc}\\t\\r\\n]", "?");
            loadLog.appendChild(this.rootNode.getOwnerDocument().createCDATASection(log));
        }
    }
}

