/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class PaymentTypeDao
extends AbstractIdDao<PaymentType>
implements Directory<PaymentType> {
    public PaymentTypeDao(Connection con) {
        super(con, 0, "contract_payment_types");
    }

    @Override
    public PaymentType get(String title) throws BGException {
        return null;
    }

    @Override
    public List<PaymentType> list() throws BGException {
        return this.list(null, null);
    }

    public List<PaymentType> list(Integer editable, Integer type) throws BGException {
        ArrayList<PaymentType> list = new ArrayList<PaymentType>();
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM contract_payment_types WHERE 1=1 ");
            int index = 1;
            if (editable != null && editable > -1) {
                query.append(" AND flag=?");
            }
            if (type != null && type > -1) {
                query.append(" AND type=?");
            }
            query.append(" ORDER BY title");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (editable != null && editable > -1) {
                ps.setInt(index++, editable);
            }
            if (type != null && type > -1) {
                ps.setInt(index, type);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public PaymentTypeItem getTree(int editable, boolean showEmptyRoot) throws BGException {
        PaymentTypeItem rootItem = new PaymentTypeItem();
        rootItem.setTitle("\u0422\u0438\u043f\u044b");
        rootItem.setType(1);
        rootItem.setEditable(true);
        this.addChild(rootItem.getId(), rootItem, this.list(editable, null), showEmptyRoot);
        return rootItem;
    }

    public void move(int paymentTypeId, List<Integer> idList) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT up, type FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, paymentTypeId);
            HashSet<Integer> parentIds = new HashSet<Integer>();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if (rs.getInt(2) != 1) {
                    rs.close();
                    ps.close();
                    return;
                }
                int parentId = rs.getInt(1);
                while (true) {
                    parentIds.add(parentId);
                    ps.setInt(1, parentId);
                    rs = ps.executeQuery();
                    if (!rs.next()) break;
                    parentId = rs.getInt(1);
                }
                rs.close();
            } else {
                paymentTypeId = 0;
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET up=? WHERE id!=? AND id=?");
            ps.setInt(1, paymentTypeId);
            ps.setInt(2, paymentTypeId);
            for (Integer i : idList) {
                if (parentIds.contains(i)) continue;
                ps.setInt(3, i);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Override
    public void update(PaymentType paymentType) throws BGException {
        if (paymentType == null || paymentType.getParentId() < 0 || paymentType.getType() < 0 || paymentType.getType() > 1) {
            throw new BGIllegalArgumentException();
        }
        try {
            if (paymentType.getId() > 0) {
                this.updateImpl(paymentType);
            } else {
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, up, type, flag) VALUES(?,?,?,?)", 1);
                ps.setString(1, paymentType.getTitle());
                ps.setInt(2, paymentType.getParentId());
                ps.setInt(3, paymentType.getType());
                ps.setBoolean(4, !paymentType.getEditable());
                ps.executeUpdate();
                paymentType.setId(ServerUtils.lastInsertId(ps));
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateImpl(PaymentType b) throws BGException, SQLException {
        PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, type=?, flag=?, up=? WHERE id=?");
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getType());
        ps.setBoolean(3, !b.getEditable());
        ps.setInt(4, b.getParentId());
        ps.setInt(5, b.getId());
        ps.executeUpdate();
        ps.close();
    }

    protected PaymentType getFromRS(ResultSet rs) throws SQLException, BGException {
        PaymentType payment = new PaymentType();
        payment.setId(rs.getInt("id"));
        payment.setTitle(rs.getString("title"));
        payment.setType(rs.getInt("type"));
        payment.setEditable(!rs.getBoolean("flag"));
        payment.setParentId(rs.getInt("up"));
        return payment;
    }

    @Override
    public int delete(int id) throws BGException {
        String query = "SELECT * FROM contract_payment WHERE pt= " + id + " LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u043e! \u0414\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return super.delete(id);
    }

    public Map<Integer, PaymentType> getTypeMapByIds(List<Integer> typeIds) throws BGException {
        HashMap<Integer, PaymentType> resultMap = new HashMap<Integer, PaymentType>();
        for (PaymentType paymentType : this.list((String)(typeIds != null && typeIds.size() > 0 ? "id IN ( " + Utils.toString(typeIds) + " )" : ""), null, new Object[0])) {
            resultMap.put(paymentType.getId(), paymentType);
        }
        return resultMap;
    }

    protected void addChild(int up, PaymentTypeItem rootItem, List<PaymentType> list, boolean showEmptyRoot) {
        for (PaymentType listItem : list) {
            if (up != listItem.getParentId()) continue;
            PaymentTypeItem ptItem = new PaymentTypeItem(listItem);
            rootItem.addChild(ptItem);
            this.addChild(ptItem.getId(), ptItem, list, showEmptyRoot);
            if (showEmptyRoot || !ptItem.isEmpty() || ptItem.getType() != 1) continue;
            rootItem.removeChild(ptItem);
        }
    }
}

