/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.bgsecure.ActionsPanel;
import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.client.ContractParameterTableModel;
import ru.bitel.bgbilling.kernel.bgsecure.client.GroupManager;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuPanel;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuRestrictPanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.Group;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserGroup;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class GroupEditor
extends BGUPanel {
    private int id = 0;
    private boolean init = false;
    private GroupManager groupManager;
    private BGTextField title = new BGTextField();
    private ActionsPanel actionsPanel = new ActionsPanel();
    private BGControlPanelListSelect groupList = new BGControlPanelListSelect();
    private ContractParameterTableModel objectParameterTableModel = new ContractParameterTableModel("groupObjectParameterAccess");
    private ContractParameterTableModel contractParameterTableModel = new ContractParameterTableModel("groupContractParameterAccess");
    private JRadioButton contractGroupsMode1 = new JRadioButton("\u0418");
    private JRadioButton contractGroupsMode0 = new JRadioButton("\u0418\u041b\u0418");
    private JTabbedPane tabbed = new JTabbedPane();
    private MenuRestrictPanel menuRestrictPanel = new MenuRestrictPanel(true);
    private MenuPanel menuPanel = new MenuPanel();
    private UserService userService;
    private UserGroupService userGroupService;

    public GroupEditor(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    protected void jbInit() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        topPanel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.getTabbedPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getButtonsPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
    }

    private JPanel getButtonsPanel() {
        JButton restoreActionButton = new JButton("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        restoreActionButton.addActionListener(e -> this.setData());
        JButton updateActionButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        updateActionButton.addActionListener(e -> this.updatePermitions());
        JButton closeActionButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        closeActionButton.addActionListener(e -> this.groupManager.hideEditorPanel());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)restoreActionButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)updateActionButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)closeActionButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JTabbedPane getTabbedPanel() {
        final JComboBox<String> cellEditorComboBox = new JComboBox<String>(this.contractParameterTableModel.getGroupEditerItems());
        DefaultCellEditor cellEditor = new DefaultCellEditor(cellEditorComboBox){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                cellEditorComboBox.setSelectedIndex(Utils.parseInt((String)String.valueOf(value)));
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }

            @Override
            public Object getCellEditorValue() {
                return cellEditorComboBox.getSelectedIndex();
            }
        };
        BGUTable objectParameterTable = new BGUTable((TableModel)((Object)this.objectParameterTableModel));
        objectParameterTable.setSelectionMode(0);
        objectParameterTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        objectParameterTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        BGUTable contractParameterTable = new BGUTable((TableModel)((Object)this.contractParameterTableModel));
        contractParameterTable.setSelectionMode(0);
        contractParameterTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        contractParameterTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.contractGroupsMode0);
        buttonGroup.add(this.contractGroupsMode1);
        this.groupList.setToolTipText("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432, \u0441 \u043a\u043e\u0442\u043e\u0440\u044b\u043c\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        JPanel contractGroupPanel = new JPanel(new GridBagLayout());
        contractGroupPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        contractGroupPanel.add((Component)this.contractGroupsMode1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        contractGroupPanel.add((Component)this.contractGroupsMode0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        contractGroupPanel.add((Component)this.groupList, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        this.tabbed.addTab("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f", (Component)this.actionsPanel);
        this.tabbed.addTab("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", contractGroupPanel);
        this.tabbed.addTab("\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", new JScrollPane((Component)contractParameterTable));
        this.tabbed.addTab("\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432", new JScrollPane((Component)objectParameterTable));
        this.tabbed.addTab("\u041f\u0443\u043d\u043a\u0442\u044b \u043c\u0435\u043d\u044e", (Component)((Object)this.menuRestrictPanel));
        this.tabbed.addTab("\u041c\u0435\u043d\u044e", (Component)((Object)this.menuPanel));
        return this.tabbed;
    }

    public void init(String module, int moduleId) {
        this.actionsPanel.init(((ClientContext)this.getContext()).getModule(), ((ClientContext)this.getContext()).getModuleId());
        this.actionsPanel.setData();
    }

    public void setData() {
        if (!this.init) {
            this.init = true;
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ListGroups");
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList((JList)this.groupList.getList(), (Node)XMLUtils.selectNode((Node)doc, (String)"//groups"));
            }
            try {
                JSONObject json = this.getUserService().contractParameters(0);
                this.contractParameterTableModel.setDefault(Utils.parseInteger((String)json.getString("groupDefaultRead"), (Integer)1), Utils.parseInteger((String)json.getString("groupDefaultWrite"), (Integer)1));
                this.contractParameterTableModel.setData(json.getJSONArray("contractParameters"));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            request = new Request();
            request.setModule("contract.object");
            request.setAction("ParamTable");
            doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table");
                this.objectParameterTableModel.setDefault(Utils.parseInteger((String)tableElement.getAttribute("groupDefaultRead"), (Integer)1), Utils.parseInteger((String)tableElement.getAttribute("groupDefaultWrite"), (Integer)1));
                JSONArray jsonArray = new JSONArray();
                for (Element element : XMLUtils.selectElements((Node)tableElement, (String)"data/row")) {
                    JSONObject row = new JSONObject();
                    row.put("id", (Object)element.getAttribute("id"));
                    row.put("title", (Object)element.getAttribute("title"));
                    jsonArray.put((Object)row);
                }
                this.objectParameterTableModel.setData(jsonArray);
            }
        }
        try {
            Group group = this.getUserGroupService().getGroupById(this.id);
            if (group != null) {
                this.title.setText(group.getTitle());
                this.groupList.setListValues(Utils.maskToEnum((long)group.getContractGroups()));
                if (group.getRuleAccessObjectParameter() != null) {
                    this.objectParameterTableModel.setValues(group.getRuleAccessObjectParameter());
                }
                if (group.getRuleAccessContractParameter() != null) {
                    this.contractParameterTableModel.setValues(group.getRuleAccessContractParameter());
                }
                (group.getContractGroupsMode() > 0 ? this.contractGroupsMode1 : this.contractGroupsMode0).setSelected(true);
                this.actionsPanel.setActions(this.getUserGroupService().getActionsOfGroup(this.id));
                this.menuRestrictPanel.setUserOrGroupId(this.id);
                this.menuRestrictPanel.setData();
                this.menuPanel.setSelected(group.getMenuId());
                this.menuPanel.setData();
                this.tabbed.setSelectedIndex(0);
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void updatePermitions() {
        String text = this.title.getText();
        if (text.isBlank()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return;
        }
        try {
            this.getUserGroupService().updateUserGroup(new UserGroup(this.id, text));
            this.groupManager.performAction("refresh");
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        try {
            Group group = new Group();
            group.setId(this.id);
            group.setMenuId(this.menuPanel.getSelectedId());
            group.setTitle(this.title.getText());
            group.setContractGroups(this.groupList.getValue());
            group.setRuleAccessObjectParameter(Utils.toList((String)this.objectParameterTableModel.getValues(), (String)","));
            group.setRuleAccessContractParameter(Utils.toList((String)this.contractParameterTableModel.getValues(), (String)","));
            this.getUserGroupService().updateGroup(group, this.actionsPanel.getActions());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.menuRestrictPanel.updateData();
    }

    private UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)((ClientContext)this.getContext()).getPort(UserService.class);
        }
        return this.userService;
    }

    private UserGroupService getUserGroupService() {
        if (this.userGroupService == null) {
            this.userGroupService = (UserGroupService)((ClientContext)this.getContext()).getPort(UserGroupService.class);
        }
        return this.userGroupService;
    }

    public void setId(int id) {
        this.id = id;
    }
}

