/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.bean.CDATA;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.webapi.server.WebApi;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebServlet(name="webApiEexecuter", urlPatterns={"/jsonWebApi/*", "/xmlWebApi/*"})
public class WebApiExecutor
extends CommonExecutor {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        if (!this.setup.getBoolean("web.api.enable", false)) {
            response.sendError(403, "web.api.enable=false");
            return;
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        request.setAttribute("dataMap", dataMap);
        dataMap.put("status", "Ok");
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        String[] pathInfoParts = pathInfo.substring(1).split("/");
        if (pathInfoParts.length == 1) {
            WebApi webApi = new WebApi(request);
            try {
                WebApi.class.getMethod(pathInfoParts[0], new Class[0]).invoke((Object)webApi, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                webApi.setError(4, "M\u0435\u0442\u043e\u0434 '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d".replace("{1}", pathInfoParts[0]));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (pathInfoParts.length == 2) {
            int moduleId = Utils.parseInt((String)pathInfoParts[0]);
            if (moduleId > 0) {
                BGModule module = ModuleCache.getInstance().getModule(moduleId);
                if (module != null) {
                    try {
                        Class<?> clazz = Class.forName(module.getInstalledModule().getPackageServer() + ".api.WebApi");
                        Object webApi = clazz.getConstructor(HttpServletRequest.class, Integer.TYPE).newInstance(request, moduleId);
                        clazz.getMethod(pathInfoParts[1], new Class[0]).invoke(webApi, new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
                        new WebApi(request).setError(4, exception.getMessage());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        new WebApi(request).setError(4, "M\u0435\u0442\u043e\u0434 '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d".replace("{1}", pathInfoParts[1]));
                    }
                } else {
                    new WebApi(request).setError(6, "\u041c\u043e\u0434\u0443\u043b\u044c \u0441 \u043a\u043e\u0434\u043e\u043c '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d".replace("{1}", String.valueOf(moduleId)));
                }
            }
        } else {
            dataMap.put("status", "Error");
            dataMap.put("errorCode", 5);
            dataMap.put("errorMessage", "\u041d\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430");
        }
        if (servletPath.endsWith("/xmlWebApi")) {
            response.setContentType("text/xml; charset=UTF-8");
            Document doc = XMLUtils.newDocument();
            Element responseNode = doc.createElement("response");
            doc.appendChild(responseNode);
            for (String key : dataMap.keySet()) {
                this.objectToXml(dataMap.get(key), XMLUtils.createElement((Element)responseNode, (String)key));
            }
            out = response.getWriter();
            XMLUtils.serialize((Node)doc.getDocumentElement(), (Result)new StreamResult(out), (String)"UTF-8", (boolean)true);
            out.flush();
            out.close();
        } else if (servletPath.endsWith("/jsonWebApi")) {
            String type = request.getHeader("Content-Type");
            boolean isMultipart = type != null && type.startsWith("multipart/form-data");
            response.setContentType((isMultipart ? "text/plain" : "application/json") + "; charset=UTF-8");
            this.replaceCDATAToString(dataMap);
            out = response.getWriter();
            out.print(new JSONObject(dataMap).toString());
            out.flush();
            out.close();
        }
    }

    private void replaceCDATAToString(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                this.replaceCDATAToString((Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof ArrayList) {
                for (Object arrayItem : (List)entry.getValue()) {
                    if (!(arrayItem instanceof Map)) continue;
                    this.replaceCDATAToString((Map)arrayItem);
                }
                continue;
            }
            if (!(entry.getValue() instanceof CDATA)) continue;
            entry.setValue(entry.getValue().toString());
        }
    }

    protected void objectToXml(Object obj, Element element) {
        if (obj != null) {
            if (obj instanceof Map) {
                Map objectMap = (Map)obj;
                for (Object key : objectMap.keySet()) {
                    Element keyElement = XMLUtils.createElement((Element)element, (String)((String)key));
                    this.objectToXml(objectMap.get(key), keyElement);
                }
            } else if (obj instanceof List) {
                for (Object item : (List)obj) {
                    String listItemName = element.getNodeName();
                    listItemName = listItemName.endsWith("s") ? listItemName.substring(0, listItemName.length() - 1) : "item";
                    Element keyElement = XMLUtils.createElement((Element)element, (String)listItemName);
                    this.objectToXml(item, keyElement);
                }
            } else if (obj instanceof CDATA) {
                element.appendChild(element.getOwnerDocument().createCDATASection(obj.toString()));
            } else {
                XMLUtils.createTextNode((Node)element, (String)obj.toString());
            }
        }
    }
}

