/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.tariff.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class DestinationTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"destination");
    private JLabel view;
    private BGComboBox<IdTitle> destCombo;
    private Directory destDir;
    private JPanel propsPanel;
    private JPanel yesNoPanel;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view = new JLabel(icon, 2);
        this.destDir = this.getDirManager().getDirectory("destinations");
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public JPanel getEditor() {
        this.loadData();
        return this.propsPanel;
    }

    @Override
    protected void loadData() {
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        Map<String, String> data = this.getDataInHash();
        this.setDirectoryItemSelection((JComboBox<? extends IdTitle>)this.destCombo, Utils.parseInt((String)data.get("dest"), (int)0));
    }

    private void createPropsPanel() {
        this.propsPanel = new JPanel();
        this.yesNoPanel = new JPanel();
        this.propsPanel.setLayout(new GridBagLayout());
        this.destCombo = new BGComboBox();
        this.buildDirectoryCombo(this.destDir, (JComboBox<IdTitle>)this.destCombo);
        IdTitle di = new IdTitle();
        di.setId(0);
        di.setTitle("-- \u043d\u0435\u0442 --");
        this.destCombo.insertItemAt((Object)di, 0);
        this.destCombo.setSelectedIndex(0);
        this.propsPanel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add((Component)this.destCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.propsPanel.add((Component)this.getDirectoryAddPanel(this.destDir, this.destCombo, true), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.yesNoPanel.setLayout(new GridBagLayout());
        JButton okButton = new JButton("\u041e\u041a");
        okButton.addActionListener(e -> this.okPressed());
        JButton canceButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        canceButton.addActionListener(e -> this.cancelPressed());
        this.yesNoPanel.add(Box.createHorizontalStrut(4), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.yesNoPanel.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.yesNoPanel.add((Component)canceButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.propsPanel.add((Component)this.yesNoPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void okPressed() {
        this.serializeData();
        this.saveData();
        this.updateView();
        this.tree.updateTree();
        this.tree.getViewableTree().stopEditing();
    }

    private void cancelPressed() {
        this.loadData();
        this.tree.getViewableTree().stopEditing();
    }

    private void updateView() {
        Map<String, String> data = this.getDataInHash();
        String dest = data.get("dest");
        String destTitle = this.destDir.getValue(Utils.parseInt((String)dest, (int)0));
        this.view.setText("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:" + destTitle);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        IdTitle di = (IdTitle)this.destCombo.getSelectedItem();
        if (di != null) {
            data.put("dest", String.valueOf(di.getId()));
        }
        this.setDataInHash(data);
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    @Override
    protected JPanel getEditorPanel() {
        return new JPanel();
    }
}

