/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.ListValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ListValueManager {
    private Connection con;
    private static final String TABLE_NAME = "object_list_value";

    public ListValueManager(Connection con) {
        this.con = con;
    }

    public Map<Integer, ListValue> getValuesMap() {
        HashMap<Integer, ListValue> result = new HashMap<Integer, ListValue>();
        try {
            String query = "SELECT * FROM object_list_value";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ListValue value = this.getListValueFromRs(rs);
                result.put(value.getId(), value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ListValue getValue(int id) {
        ListValue result = null;
        try {
            String query = "SELECT * FROM object_list_value WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getListValueFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ListValue> getValues(int listParamId) {
        ArrayList<ListValue> result = new ArrayList<ListValue>();
        try {
            String query = "SELECT * FROM object_list_value WHERE param_id=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, listParamId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getListValueFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateValue(ListValue value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (value.getId() <= 0) {
                query = "INSERT INTO object_list_value (title, param_id) VALUES (?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(2, value.getParamId());
            } else {
                query = "UPDATE object_list_value SET title=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(2, value.getId());
            }
            ps.setString(1, value.getTitle());
            ps.executeUpdate();
            if (value.getId() <= 0) {
                value.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteValue(int id) {
        try {
            String query = "DELETE FROM object_list_value WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ListValue getListValueFromRs(ResultSet rs) throws SQLException {
        ListValue result = new ListValue();
        result.setId(rs.getInt("id"));
        result.setParamId(rs.getInt("param_id"));
        result.setTitle(rs.getString("title"));
        return result;
    }
}

