/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractCommentPatternEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class CommentPatternManager {
    private final Logger logger = LogManager.getLogger();
    private Connection con;

    public CommentPatternManager(Connection connection) {
        this.con = connection;
    }

    public List<IdTitle> getContractCommentPatternList() throws SQLException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        try (PreparedStatement psSelect = this.con.prepareStatement("SELECT id, title FROM contract_comment_patterns");
             ResultSet rs = psSelect.executeQuery();){
            while (rs.next()) {
                list.add(new IdTitle(rs.getInt(1), rs.getString(2)));
            }
        }
        return list;
    }

    public List<Integer> getCidsByPatternId(int patid) throws SQLException {
        ArrayList<Integer> cids = new ArrayList<Integer>();
        String query = "SELECT id FROM contract WHERE title_pattern_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, patid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            cids.add(Utils.parseInt((String)rs.getString(1)));
        }
        rs.close();
        ps.close();
        return cids;
    }

    public void updateContractComment(int contractId) throws SQLException {
        int patternId = 0;
        String query = "SELECT title_pattern_id FROM contract WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, contractId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            patternId = rs.getInt(1);
        }
        rs.close();
        ps.close();
        if (patternId > 0) {
            ps = this.con.prepareStatement("UPDATE contract SET comment=? WHERE id=?");
            ps.setString(1, this.transformValueToComment(patternId, contractId));
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
        }
    }

    public String transformValueToComment(int patternId, int contractId) throws SQLException {
        String rawValue = "";
        try (PreparedStatement ps = this.con.prepareStatement("SELECT pat FROM contract_comment_patterns WHERE id=?");){
            ps.setInt(1, patternId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    rawValue = rs.getString(1);
                }
            }
        }
        ContractCommentPatternEvent event = new ContractCommentPatternEvent(contractId, rawValue);
        try {
            rawValue = EventProcessor.getInstance().request(event).getCommentPattern();
        }
        catch (BGException e1) {
            this.logger.error((Object)e1);
        }
        if (Utils.notBlankString((String)rawValue)) {
            Set<String> clientKeys;
            Set<Integer> pids = this.getPids(rawValue);
            if (!pids.isEmpty()) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    Map<Integer, String> values = contractDao.getContractParameterValuesForParameterIds(contractId, pids);
                    for (int key : pids) {
                        rawValue = rawValue.replaceAll("\\$\\{param_" + key + "\\}", Utils.maskNull((String)values.get(key)));
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
            if (!(clientKeys = this.getClientKeys(rawValue)).isEmpty()) {
                CustomerDao customerDao = new CustomerDao(this.con);
                try {
                    Optional<CustomerLink> customerLink = customerDao.getCustomerLink(contractId, LocalDateTime.now());
                    if (customerLink.isPresent()) {
                        JSONObject customer = customerDao.getCustomerDataJson(customerLink.get().getCustomerId());
                        for (String key : clientKeys) {
                            rawValue = rawValue.replaceAll("\\$\\{client:" + key + "\\}", String.valueOf(customer.optQuery(key)));
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
        }
        return rawValue;
    }

    private Set<Integer> getPids(String val) {
        int found;
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        int last = 0;
        while ((found = val.indexOf("${param_", last)) != -1) {
            last = found + 8;
            found = val.indexOf("}", last);
            Integer pid = Utils.parseInt((String)val.substring(last, found));
            result.add(pid);
        }
        return result;
    }

    private Set<String> getClientKeys(String val) {
        int found;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int last = 0;
        while ((found = val.indexOf("${client:", last)) != -1) {
            last = found + 9;
            found = val.indexOf("}", last);
            result.add(val.substring(last, found));
        }
        return result;
    }
}

