/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractParamBeforeChangeEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.server.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionUpdateAddressInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int pid = this.getIntParameter("pid", -1);
        int hid = this.getIntParameter("hid", -1);
        int pod = this.getIntParameter("pod", 0);
        int floor = this.getIntParameter("floor", 0);
        int formatKey = this.getIntParameter("formatKey", 0);
        AddressStruct addressStruct = AddressUtils.getAddressStruct(this.con, hid, this.getParameter("flat"), this.getParameter("room", "").trim(), pod > 0 ? String.valueOf(pod) : null, floor != 0 ? String.valueOf(floor) : null, this.getParameter("comment", ""));
        EntityAttrAddress entityAttrAddress = new EntityAttrAddress(0, pid);
        entityAttrAddress.setHouseId(hid);
        entityAttrAddress.setFlat(addressStruct.getFlat());
        entityAttrAddress.setRoom(addressStruct.getRoom());
        entityAttrAddress.setPod(pod);
        entityAttrAddress.setFloor(floor);
        entityAttrAddress.setComment(addressStruct.getComment());
        ContractAddressParamValue value = new ContractAddressParamValue();
        value.setHouseId(hid);
        value.setFlat(addressStruct.getFlat());
        value.setRoom(addressStruct.getRoom());
        value.setPod(pod);
        value.setFloor(floor);
        value.setComment(addressStruct.getComment());
        String sortOrder = this.setup.get("addrs.format.list", null);
        if (sortOrder != null) {
            String[] orderValues = sortOrder.trim().split(";");
            String format = "";
            format = formatKey < 1 ? String.valueOf(0) : orderValues[formatKey - 1];
            value.setFormatKey(format);
            entityAttrAddress.setFormatKey(format);
            String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, format);
            value.setAddress(fullAddress);
            entityAttrAddress.setTitle(fullAddress);
        } else {
            value.setFormatKey("");
            entityAttrAddress.setFormatKey("");
            String fullAddress = AddressUtils.getAddress(this.setup, addressStruct, "cp" + pid);
            value.setAddress(fullAddress);
            entityAttrAddress.setTitle(fullAddress);
        }
        ContractParamBeforeChangeEvent checkEvent = new ContractParamBeforeChangeEvent((int)this.userId, this.cid, pid, value);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        if (Utils.notBlankString((String)checkEvent.getError())) {
            throw new BGMessageException(checkEvent.getError());
        }
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            contractDao.updateContractParameter(this.cid, (EntityAttr)entityAttrAddress);
            new CommentPatternManager(this.con).updateContractComment(this.cid);
            this.context.publishAfterCommit(new ContractParamChangedEvent((int)this.userId, this.cid, pid, value));
        }
    }
}

