/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractService;
import bitel.billing.server.contract.bean.ContractServiceManager;
import java.sql.SQLException;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.BeforeServiceDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractServicesChangedEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;

public class ActionDeleteContractService
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        ContractServiceManager csm;
        ContractService contractService;
        int id = this.getIntParameter("id", -1);
        if (id > -1 && (contractService = (csm = new ContractServiceManager(this.con)).getContractServiceById(id)) != null) {
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionDeleteContractService", this.mid, this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForDelete(closedDate, contractService.getDateFrom());
            }
            EventProcessor.getInstance().request(new BeforeServiceDeleteEvent(this.userId, contractService));
            csm.deleteContractService(id);
            this.context.publishAfterCommit(new ContractServicesChangedEvent(this.cid));
        }
    }
}

