/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractTariff;
import bitel.billing.server.contract.bean.ContractTariffManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffGroupManager;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.TimeUtils;

public class ActionContractTariffPlan
extends ActionBase {
    @Override
    public void doAction() throws BGException {
        int id = this.getIntParameter("id", -1);
        if (id < -1) {
            throw new BGIllegalArgumentException();
        }
        int tpid = 0;
        if (id > 0) {
            Element tariffPlan = this.createElement(this.rootNode, "tariffPlan");
            ContractTariff contractPlan = new ContractTariffManager(this.con).getContractTariffById(id);
            tpid = contractPlan.getTariffPlanId();
            tariffPlan.setAttribute("tpid", String.valueOf(tpid));
            tariffPlan.setAttribute("date1", TimeUtils.formatDate((Calendar)contractPlan.getDate1()));
            tariffPlan.setAttribute("date2", TimeUtils.formatDate((Calendar)contractPlan.getDate2()));
            tariffPlan.setAttribute("comment", contractPlan.getComment());
            tariffPlan.setAttribute("pos", String.valueOf(contractPlan.getPos()));
        }
        int moduleId = this.getIntParameter("mid", -1);
        boolean showUsed = this.getIntParameter("showUsed", 0) == 1;
        boolean useFilter = this.getIntParameter("useFilter", 0) == 1;
        boolean tariffGroupFilter = this.getIntParameter("tariffGroupFilter", 0) == 1;
        Element plansElement = this.createElement(this.rootNode, "tariffPlans");
        if (!useFilter) {
            this.listAvaliableTariffPlans(plansElement, tpid, showUsed, tariffGroupFilter, moduleId);
        } else {
            if (this.cid < 0) {
                return;
            }
            ContractDao contractDao = new ContractDao(this.con, 0);
            Contract contract = (Contract)contractDao.get(this.cid);
            List<Integer> contractLabelIds = new ContractLabelManager(this.con).getContractLabelIds(this.cid);
            this.listAvaliableTariffPlans(plansElement, tpid, showUsed, moduleId, contractLabelIds, contract.getPersonType(), contract.getTitle(), tariffGroupFilter);
            contractDao.close();
        }
    }

    private void listAvaliableTariffPlans(Element element, int defaultID, boolean getUsed, boolean tariffGroupFilter, int mid) throws BGException {
        try (TariffPlanDao planManager = new TariffPlanDao(this.con);
             TariffGroupManager tariffGroupManager = new TariffGroupManager(this.con);){
            for (TariffPlan plan : planManager.list()) {
                if (plan.getId() != defaultID && (getUsed && !plan.isUsed() || !planManager.usesModule(plan.getId(), mid) && mid >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(plan, tariffGroupManager))) continue;
                this.addListItem((Node)element, plan.getId(), plan.getTitle());
            }
        }
    }

    private void listAvaliableTariffPlans(Element element, int defaultID, boolean getUsed, int moduleId, List<Integer> contracLabelIds, int face, String title, boolean tariffGroupFilter) throws BGException {
        try (TariffPlanDao planManager = new TariffPlanDao(this.con);
             TariffGroupManager tariffGroupManager = new TariffGroupManager(this.con);){
            for (TariffPlan plan : planManager.getTariffPlanList(defaultID, contracLabelIds, face, title)) {
                if (plan.getId() != defaultID && (getUsed && !plan.isUsed() || !planManager.usesModule(plan.getId(), moduleId) && moduleId >= 0 || tariffGroupFilter && !this.isPlanInContractTariffGroup(plan, tariffGroupManager))) continue;
                this.addListItem((Node)element, plan.getId(), plan.getTitle());
            }
        }
    }

    private boolean isPlanInContractTariffGroup(TariffPlan plan, TariffGroupManager tariffGroupManager) throws BGException {
        boolean result;
        block6: {
            result = false;
            Date dt = new Date();
            try (ContractTariffGroupDao contractTariffGroupDao = new ContractTariffGroupDao(this.con);){
                ContractTariffGroup contractTariffGroup = (ContractTariffGroup)contractTariffGroupDao.get(this.cid);
                if (contractTariffGroup == null) break block6;
                TariffGroup tariffGroup = tariffGroupManager.getTariffGroupById(contractTariffGroup.getTariffGroupId());
                List<TariffGroupTariff> tariffGroupItems = tariffGroup.getPlanList();
                for (TariffGroupTariff tariffItem : tariffGroupItems) {
                    if (!TimeUtils.dateInRange((Date)dt, (Date)tariffItem.getDate1(), (Date)tariffItem.getDate2()) || tariffItem.getId() != plan.getId()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

