/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.server.admin.resource.action.base.ActionBase;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.IPNResourceManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionIPResourceAdd
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        long ip2;
        long ip1;
        boolean maskMode;
        int categoryId = this.getIntParameter("category_id", 0);
        Calendar date = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date"));
        if (this.mid <= 0 || categoryId < 0 || date == null) {
            throw new BGIllegalArgumentException();
        }
        String fromNumber = this.getParameter("range1");
        String toNumber = this.getParameter("range2");
        String net = this.getParameter("net");
        String mask = this.getParameter("mask");
        boolean bl = maskMode = net != null;
        if (maskMode) {
            long netLong = Utils.parseLong((String)net, (long)0L);
            if (netLong <= 0L) {
                throw new BGIllegalArgumentException();
            }
            IPUtils.Netv4 netv4 = IPUtils.getNet((long)netLong, (short)((short)Utils.parseInt((String)mask, (int)0)));
            ip1 = netv4.hostMin - 1L;
            ip2 = netv4.hostMax + 1L;
        } else {
            ip1 = Utils.parseLong((String)fromNumber, (long)0L);
            ip2 = Utils.parseLong((String)toNumber, (long)0L);
        }
        if (ip1 <= 0L || ip2 <= 0L || ip2 < ip1) {
            throw new BGIllegalArgumentException();
        }
        if (ip2 >= ip1) {
            IPNResourceManager resourceManager = new IPNResourceManager(this.con, this.mid);
            try {
                resourceManager.checkResource(ip1, ip2, date);
            }
            catch (BGException e) {
                throw new BGException(e.getMessage());
            }
            resourceManager.addResources(categoryId, date, ip1, ip2);
        }
    }
}

