/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.ActionDirectoryBase;
import bitel.billing.server.admin.bean.AddressManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionUpdateAddressDirectory
extends ActionDirectoryBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        String title = this.getParameter("title");
        String flag = this.getParameter("flag", "");
        if (title == null) {
            throw new BGMessageException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        int mode = this.getIntParameter("mode", -1);
        AddressManager addressManager = new AddressManager(this.con, this.setup);
        String table = this.getTable(mode);
        if (table == null) {
            throw new BGMessageException("Not found table, mode=" + mode);
        }
        if (mode == 20) {
            String query = id != -1 ? "UPDATE " + table + " SET title=?  WHERE id=?" : "INSERT INTO " + table + " SET title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int ind = 1;
            ps.setString(ind++, title);
            if (id != -1) {
                ps.setInt(ind++, id);
            }
            ps.executeUpdate();
            if (id == -1) {
                id = ServerUtils.lastInsertId(this.con);
            }
            ps.close();
            this.updateAddressParams(id, flag, addressManager, "address_country");
        } else if (mode == 5) {
            int pos = this.getIntParameter("pos", 1);
            int countryId = this.getIntParameter("countryId", -1);
            String query = id != -1 ? "UPDATE " + table + " SET title=?, pos=?, country_id=? WHERE id=?" : "INSERT INTO " + table + " SET title=?, pos=?, country_id=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            int ind = 1;
            ps.setString(ind++, title);
            ps.setInt(ind++, pos);
            ps.setInt(ind++, countryId);
            if (id != -1) {
                ps.setInt(ind++, id);
            }
            ps.executeUpdate();
            if (id == -1) {
                id = ServerUtils.lastInsertId(this.con);
            }
            ps.close();
            this.updateAddressParams(id, flag, addressManager, "address_city");
        } else if (mode == 7) {
            String index = this.getParameter("index");
            String cityid = this.getParameter("cityid");
            String query = id != -1 ? "UPDATE " + table + " SET title=?, p_index=?, cityid=? WHERE id=?" : "INSERT INTO " + table + " SET title=?, p_index=?, cityid=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            int ind = 1;
            ps.setString(ind++, title);
            if (flag.equals("new")) {
                index = "";
            }
            ps.setString(ind++, index);
            ps.setString(ind++, cityid);
            if (id != -1) {
                ps.setInt(ind++, id);
            }
            ps.executeUpdate();
            if (id == -1) {
                id = ServerUtils.lastInsertId(this.con);
            }
            this.updateAddressParams(id, flag, addressManager, "address_street");
        } else if (mode == 6) {
            String cityid = this.getParameter("cityid");
            String query = id != -1 ? "UPDATE " + table + " SET title=?, cityid=? WHERE id=?" : "INSERT INTO " + table + " SET title=?, cityid=? ";
            PreparedStatement ps = this.con.prepareStatement(query);
            int ind = 1;
            ps.setString(ind++, title);
            ps.setString(ind++, cityid);
            if (id != -1) {
                ps.setInt(ind++, id);
            }
            ps.executeUpdate();
            if (id == -1) {
                id = ServerUtils.lastInsertId(this.con);
            }
            ps.close();
            this.updateAddressParams(id, flag, addressManager, "address_area");
        } else if (mode == 8) {
            int gid = this.getIntParameter("gid", 0);
            String cityid = this.getParameter("cityid");
            String query = id != -1 ? "UPDATE " + table + " SET title=?, gid=?, cityid=? WHERE id=?" : "INSERT INTO " + table + " SET title=?, gid=?, cityid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            int ind = 1;
            ps.setString(ind++, title);
            ps.setInt(ind++, gid);
            ps.setString(ind++, cityid);
            if (id != -1) {
                ps.setInt(ind++, id);
            }
            ps.executeUpdate();
            if (id == -1) {
                id = ServerUtils.lastInsertId(this.con);
            }
            ps.close();
            this.updateAddressParams(id, flag, addressManager, "address_quarter");
        }
        switch (mode) {
            case 5: {
                AddressUtils.onUpdateAddressCity(this.setup, id);
                break;
            }
            case 6: {
                AddressUtils.onUpdateAddressArea(this.setup, id);
                break;
            }
            case 7: {
                AddressUtils.onUpdateAddressStreet(this.setup, id);
                break;
            }
            case 8: {
                AddressUtils.onUpdateAddressQuarter(this.setup, id);
            }
        }
    }

    private void updateAddressParams(int id, String flag, AddressManager addressManager, String tableName) {
        String config;
        if (flag.equals("new")) {
            // empty if block
        }
        if ((config = this.getParameter("config")) != null && !config.isEmpty()) {
            String[] params = config.split("\r\n");
            for (int i = 0; i < params.length; ++i) {
                String[] str = params[i].split("=");
                addressManager.updateAddressParams(tableName, id, str[0], str[1]);
            }
        }
    }
}

