/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ScheduledTaskReloadEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.common.SchedulerService;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.PeriodicTask;
import ru.bitel.bgbilling.kernel.task.common.bean.RunningTask;
import ru.bitel.bgbilling.kernel.task.common.bean.SchedulerTaskLog;
import ru.bitel.bgbilling.kernel.task.server.TaskBaseRunner;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.task.common.SchedulerService")
public class SchedulerServiceImpl
extends AbstractService
implements SchedulerService {
    private SchedulerManager manager;

    @PostConstruct
    public void init() {
        this.manager = new SchedulerManager(this.getConnection());
    }

    @Override
    public List<LightweightTaskData> getSchedulerTasks(String moduleId) throws BGException {
        List<LightweightTaskData> result = this.manager.getTaskList(moduleId);
        for (LightweightTaskData item : result) {
            if (item.isPlugin()) {
                item.setModuleName(BGPluginManagerServer.getManager().getPluginByUID(item.getModuleId()).getName());
                continue;
            }
            if (item.getModuleId() == 0) {
                item.setModuleName("\u042f\u0434\u0440\u043e");
                continue;
            }
            if (item.getModuleId() <= 0) continue;
            item.setModuleName(ModuleCache.getInstance().getModule(item.getModuleId()).getTitle());
        }
        return result;
    }

    @Override
    public List<Pair<String, String>> getModuleAndPluginList() throws BGException {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        result.add(new Pair((Object)"-2", (Object)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
        result.add(new Pair((Object)"0", (Object)"\u042f\u0434\u0440\u043e"));
        result.add(new Pair((Object)"-1", (Object)"\u041c\u043e\u0434\u0443\u043b\u0438"));
        for (BGModule module : ModuleCache.getInstance().getModulesList(null)) {
            Map<String, String> moduleTasks = TaskCache.getInstance().getModuleTasks(String.valueOf(module.getId()));
            if (moduleTasks == null || moduleTasks.isEmpty()) continue;
            result.add((Pair<String, String>)new Pair((Object)String.valueOf(module.getId()), (Object)module.getTitle()));
        }
        result.add(new Pair((Object)"-1", (Object)"\u041f\u043b\u0430\u0433\u0438\u043d\u044b"));
        for (String pluginId : BGPluginManagerServer.getManager().getPluginsMap().keySet()) {
            BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin(pluginId);
            Map<String, String> pluginTasks = TaskCache.getInstance().getModuleTasks("p" + plugin.getPluginUID());
            if (pluginTasks == null || pluginTasks.isEmpty()) continue;
            result.add((Pair<String, String>)new Pair((Object)("p" + plugin.getPluginUID()), (Object)plugin.getName()));
        }
        return result;
    }

    @Override
    public List<Pair<String, String>> getAvailableSchedulerTasks(String moduleId) throws BGException {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        Map<String, String> availableTasks = TaskCache.getInstance().getModuleTasks(moduleId);
        if (availableTasks != null && availableTasks.size() > 0) {
            for (String key : availableTasks.keySet()) {
                result.add((Pair<String, String>)new Pair((Object)key, (Object)availableTasks.get(key)));
            }
        }
        return result;
    }

    @Override
    public List<Pair<String, String>> getAvailableDependTasks(String moduleId, String parentModule) throws BGException {
        return null;
    }

    @Override
    public int getActiveTaskCount() throws BGException {
        return new RunTaskDataManager(this.getConnection()).getTaskCount();
    }

    @Override
    public void updateTask(LightweightTaskData task) throws BGException {
        if (task.getId() > 0) {
            this.manager.updateTask(task);
        } else {
            this.manager.addTask(task);
        }
        EventProcessor.getInstance().publish(new ScheduledTaskReloadEvent());
    }

    @Override
    public void deleteTask(int taskId) throws BGException {
        this.manager.deleteTask(taskId);
        this.manager.deleteTaskLog();
    }

    @Override
    public void immediateRun(LightweightTaskData task) throws BGException {
        if (task != null) {
            try {
                TaskBaseRunner taskBase = new TaskBaseRunner(task.getClassName(), new Date(), task.getId(), task.getParams(), task.getModuleId());
                new RunTaskDataManager(this.getConnection()).addTask(taskBase);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        } else {
            throw new BGException("Task is null!");
        }
    }

    @Override
    public List<RunningTask> getRunningTaskList() throws BGException {
        return this.manager.getRunningTaskList();
    }

    @Override
    public List<PeriodicTask> getPeriodicTaskList() throws BGException {
        return this.manager.getPeriodicTaskLIst();
    }

    @Override
    public void deleteCurrentRunTask(int taskId) throws BGException {
        this.manager.deleteCurrentRunTask(taskId);
    }

    @Override
    public SearchResult<SchedulerTaskLog> getTaskLog(int taskId, Period period, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setPeriod(period);
        searchResult.setList(new ArrayList());
        this.manager.getTaskLog(taskId, (SearchResult<SchedulerTaskLog>)searchResult);
        return searchResult;
    }
}

