/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class EventScriptLinkDao
extends AbstractIdDao<EventScriptLink> {
    public EventScriptLinkDao(Connection con) {
        super(con, 0, "event_script_link");
    }

    protected EventScriptLink getFromRS(ResultSet rs) throws SQLException, BGException {
        EventScriptLink link = new EventScriptLink();
        link.setClassName(rs.getString("class_name"));
        link.setEventKey(rs.getString("event_key"));
        link.setId(rs.getInt("id"));
        link.setScriptId(rs.getInt("script_id"));
        link.setTitle(rs.getString("title"));
        return link;
    }

    protected void updateImpl(EventScriptLink b) throws BGException, SQLException {
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            String query = "INSERT INTO event_script_link(class_name, event_key, script_id, title) VALUES(?,?,?,?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE event_script_link SET class_name=?, event_key=?, script_id=?, title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(5, b.getId());
        }
        ps.setString(1, b.getClassName());
        ps.setString(2, b.getEventKey());
        ps.setInt(3, b.getScriptId());
        ps.setString(4, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<EventScriptLink> getScriptLinkListByScript(int scriptId) throws BGException {
        return this.list("script_id=?", "title", new Object[]{scriptId});
    }

    public List<EventScriptLink> getScriptLinkList() throws BGException {
        return this.list("", "title", new Object[0]);
    }
}

