/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.SearchResult;

public class ContractHistoryRecordDao
extends AbstractDao<ContractHistoryRecord> {
    private Lock lock = null;
    private Logger logger = LogManager.getLogger();

    public ContractHistoryRecordDao(Connection con) {
        super(con, 0, "contract_history_open_log");
        this.lock = new ReentrantLock();
    }

    public void searchContractHistoryRecord(SearchResult<ContractHistoryRecord> searchResult, int userId) throws BGException {
        if (searchResult != null) {
            try {
                int index = 1;
                List list = searchResult.getList();
                String query = "SELECT log.*, c.title AS contract_title, c.comment AS contract_comment FROM " + this.tableName + " AS log LEFT JOIN contract AS c ON c.id=log.contract_id WHERE user_id=? AND c.title IS NOT NULL ORDER BY last_open DESC LIMIT 100";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(index++, userId);
                ResultSet resultSet = ps.executeQuery();
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
                resultSet.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected ContractHistoryRecord getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractHistoryRecord contractHistoryRecord = new ContractHistoryRecord();
        contractHistoryRecord.setUserId(rs.getInt("user_id"));
        contractHistoryRecord.setContractId(rs.getInt("contract_id"));
        contractHistoryRecord.setLastOpen(rs.getTimestamp("last_open"));
        contractHistoryRecord.setContractTitle(rs.getString("contract_title"));
        contractHistoryRecord.setContractComment(rs.getString("contract_comment"));
        return contractHistoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImpl(ContractHistoryRecord contractHistoryRecord) throws BGException, SQLException {
        try {
            if (this.lock.tryLock(5L, TimeUnit.SECONDS)) {
                int index = 1;
                String query = "INSERT INTO `" + this.tableName + "` SET user_id=?, contract_id=?, last_open=? ON DUPLICATE KEY UPDATE last_open=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setInt(index++, contractHistoryRecord.getUserId());
                ps.setInt(index++, contractHistoryRecord.getContractId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)contractHistoryRecord.getLastOpen()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestampSeconds((Date)contractHistoryRecord.getLastOpen()));
                ps.executeUpdate();
                ps.close();
                if (ThreadLocalRandom.current().nextInt(9) == 0) {
                    ps = this.con.prepareStatement("DELETE FROM `" + this.tableName + "` WHERE user_id=? AND last_open < NOW() - INTERVAL 2 MONTH");
                    ps.setInt(1, contractHistoryRecord.getUserId());
                    ps.executeUpdate();
                    ps.close();
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

