/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.script.server.service;

import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.script.bean.ScriptManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.AdditionalContractAction;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.AdditionalContractActionResult;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScriptLog;
import ru.bitel.bgbilling.kernel.contract.script.common.service.ContractScriptService;
import ru.bitel.bgbilling.kernel.contract.script.server.bean.ContractScriptLogDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.AdditionalActionEvent;
import ru.bitel.bgbilling.kernel.event.events.GetAdditionalActionListEvent;
import ru.bitel.bgbilling.kernel.event.events.GetAdditionalWebActionListEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.script.common.service.ContractScriptService")
public class ContractScriptServiceImpl
extends AbstractService
implements ContractScriptService {
    @Override
    public List<String> getScriptLogTitleList(int contractId, Period period) throws BGException, BGMessageException {
        if (period == null || period.getDateFrom() == null) {
            throw new BGIllegalArgumentException();
        }
        String tableName = ServerUtils.getMonthTableName("log_function_process", period.getDateFrom());
        Connection con = this.getSetup().getDBTrashOrSlaveConnectionFromPool(tableName);
        try {
            List<String> list;
            try (ContractScriptLogDao dao = new ContractScriptLogDao(con, tableName);){
                list = dao.getScriptLogTitleList(contractId, period);
            }
            return list;
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    @Override
    public List<ContractScriptLog> getScriptLogList(int contractId, Period period, String title, Holder<Page> pageHolder) throws BGException, BGMessageException {
        if (period == null || period.getDateFrom() == null) {
            throw new BGIllegalArgumentException();
        }
        String tableName = ServerUtils.getMonthTableName("log_function_process", period.getDateFrom());
        Connection con = this.getSetup().getDBTrashOrSlaveConnectionFromPool(tableName);
        try {
            List<ContractScriptLog> list;
            try (ContractScriptLogDao dao = new ContractScriptLogDao(con, tableName);){
                list = dao.getScriptLogList(contractId, period, title, pageHolder != null ? (Page)pageHolder.value : null);
            }
            return list;
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    @Override
    public List<ContractScript> contractScriptList(int contractId) {
        ContractScriptManager contractScriptManager = new ContractScriptManager(this.getConnection());
        ArrayList<ContractScript> list = new ArrayList<ContractScript>();
        Map<Integer, Script> scriptMap = new ScriptManager(this.getConnection()).getScriptMap();
        contractScriptManager.getContractScriptList(contractId).forEach(e -> {
            ContractScript contractScript = new ContractScript();
            contractScript.setId(e.getId());
            contractScript.setScriptId(e.getScriptId());
            contractScript.setComment(e.getComment());
            contractScript.setPeriod(e.getPeriod());
            Script script = (Script)((Object)((Object)scriptMap.get(e.getScriptId())));
            if (script != null) {
                contractScript.setScript(script.getTitle());
            }
            list.add(contractScript);
        });
        return list;
    }

    @Override
    public ContractScript contractScriptGet(int id) throws BGException, BGMessageException {
        return new ContractScriptManager(this.getConnection()).getContractScriptById(id);
    }

    @Override
    public void contractScriptUpdate(ContractScript contractScript) throws BGException, BGMessageException {
        if (contractScript != null) {
            boolean result;
            Period period = contractScript.getPeriod();
            boolean bl = result = period.getDateFrom() == null || period.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)period.getDateFrom(), (Date)period.getDateTo());
            if (!result) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434!");
            }
            if (contractScript.getScriptId() >= 0 && period.getDateFrom() != null) {
                new ContractScriptManager(this.getConnection()).updateContractScript(contractScript);
            }
        }
    }

    @Override
    public void contractScriptDelete(int id) throws BGException, BGMessageException {
        new ContractScriptManager(this.getConnection()).deleteContractScript(id);
    }

    @Override
    @Deprecated
    public List<AdditionalContractAction> additionalContractActionList(int contractId, boolean customer) throws BGException, BGMessageException {
        return this.additionalContractActionList(contractId, customer, null);
    }

    @Override
    public List<AdditionalContractAction> additionalContractActionList(int contractId, boolean customer, MapHolder<String, String> params) throws BGException, BGMessageException {
        if (customer) {
            GetAdditionalWebActionListEvent event = new GetAdditionalWebActionListEvent(contractId, null);
            event.setParams((ParameterMap)new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            EventProcessor.getInstance().request(event);
            return new ArrayList<AdditionalContractAction>(event.getActionList());
        }
        GetAdditionalActionListEvent event = new GetAdditionalActionListEvent(this.userId, contractId);
        event = EventProcessor.getInstance().request(event);
        return new ArrayList<AdditionalContractAction>(event.getActionList());
    }

    @Override
    public AdditionalContractActionResult additionalContractActionInvoke(int contractId, int actionId, boolean customer, MapHolder<String, String> params) throws BGException, BGMessageException {
        if (contractId <= 0 || actionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (customer) {
            GetAdditionalWebActionListEvent event = new GetAdditionalWebActionListEvent(contractId, null);
            event.setParams((ParameterMap)new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            event = EventProcessor.getInstance().request(event);
            if (!event.actionAllowed(actionId)) {
                throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e!", "additionalContractAction.notAllowed");
            }
            AdditionalActionEvent eventAction = new AdditionalActionEvent(contractId, actionId, this.userId);
            eventAction.setParams((ParameterMap)new ParameterMap.DefaultParameterMap(params != null && params.getMap() != null ? params.getMap() : Collections.emptyMap()));
            eventAction = EventProcessor.getInstance().request(eventAction);
            AdditionalContractActionResult result = new AdditionalContractActionResult();
            result.setReport(eventAction.getReport());
            return result;
        }
        GetAdditionalActionListEvent event = new GetAdditionalActionListEvent(this.userId, contractId);
        event = EventProcessor.getInstance().request(event);
        if (!event.actionAllowed(actionId)) {
            throw new BGMessageException("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e!", "additionalContractAction.notAllowed");
        }
        AdditionalActionEvent eventAction = new AdditionalActionEvent(contractId, actionId, this.userId);
        eventAction = EventProcessor.getInstance().request(eventAction);
        AdditionalContractActionResult result = new AdditionalContractActionResult();
        result.setReport(eventAction.getReport());
        return result;
    }
}

