/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.server.task;

import java.sql.Connection;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.kernel.contract.period.server.bean.ContractPeriodDao;
import ru.bitel.bgbilling.kernel.contract.period.server.event.ContractPeriodCloseEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ContractPeriodSentCloseEvent
extends TaskBase {
    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430.";
    }

    @Override
    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (ContractPeriodDao contractPeriodDao = new ContractPeriodDao(con);){
            EventProcessor eventProcessor = EventProcessor.getInstance();
            for (ContractPeriod contractPeriod : contractPeriodDao.getContractPeriodList(this.taskSetup.getInt("period", 900))) {
                if (!contractPeriodDao.setSentCloseEventFlag(contractPeriod.getId())) continue;
                eventProcessor.publish(new ContractPeriodCloseEvent(contractPeriod, 0));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        finally {
            ServerUtils.closeConnection(con, conSlave);
        }
    }
}

