/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.server.bean;

import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.common.TimeUtils;

public class ContractParameters {
    public static Set<Integer> getContractParameterIdsInGroup(int contractParamGroupId, Connection con) throws BGException {
        Set<Integer> ids = null;
        if (contractParamGroupId > 0) {
            ids = new ContractParameterGroupManager(con).getParameterSetInGroup(contractParamGroupId);
        }
        return ids;
    }

    public static List<ContractParameterPref> getContractParameterPrefList(Set<Integer> parameterIds, Connection con) throws BGException {
        ArrayList<ContractParameterPref> list = new ArrayList<ContractParameterPref>();
        ContractParameterPrefDao prefDao = new ContractParameterPrefDao(con);
        for (ContractParameterPref contractParameterPref : prefDao.getContractParameterPrefList(parameterIds)) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            list.add(contractParameterPref);
        }
        prefDao.close();
        return list;
    }

    public static Map<Integer, String> getContractParameterValue(List<ContractParameterPref> showList, int contractId, Connection con) throws BGException {
        HashSet<Integer> paramIds = new HashSet<Integer>();
        for (ContractParameterPref contractParameterPref : showList) {
            if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
            paramIds.add(contractParameterPref.getId());
        }
        return ContractParameters.getContractParameterValue(paramIds, contractId, con);
    }

    public static Map<Integer, String> getContractParameterValue(Set<Integer> paramIds, int contractId, Connection con) throws BGException {
        Object listParamValue;
        HashMap<Integer, String> paramValue = new HashMap<Integer, String>();
        ContractParameterManager contractParameterManager = new ContractParameterManager(con);
        for (Map.Entry<Integer, String> entry : contractParameterManager.getStringParamMap(contractId, paramIds).entrySet()) {
            paramValue.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : contractParameterManager.getAddressParamMap(contractId, paramIds).entrySet()) {
            ContractAddressParamValue contractAddressParamValue = (ContractAddressParamValue)entry.getValue();
            if (contractAddressParamValue == null) continue;
            paramValue.put(entry.getKey(), contractAddressParamValue.getAddress());
        }
        for (Map.Entry<Integer, Object> entry : contractParameterManager.getEmailParamMap(contractId, paramIds).entrySet()) {
            ContractEmailParamValue contractEmailParamValue = (ContractEmailParamValue)entry.getValue();
            if (contractEmailParamValue == null || contractEmailParamValue.getEmail() == null) continue;
            String emails = contractEmailParamValue.getEmail().trim();
            emails = emails.replaceAll("\n", "; ");
            emails = emails.replaceAll("<", "&lt;");
            emails = emails.replaceAll(">", "&gt;");
            paramValue.put(entry.getKey(), emails);
        }
        for (Map.Entry<Integer, Object> entry : contractParameterManager.getFlagParamMap(contractId, paramIds).entrySet()) {
            Boolean bl = (Boolean)entry.getValue();
            if (bl == null) continue;
            paramValue.put(entry.getKey(), bl != false ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        }
        DateFormat format = TimeUtils.getDateFormat((String)"dd.MM.yyyy");
        for (Map.Entry<Integer, Date> entry : contractParameterManager.getDateParamMap(contractId, paramIds).entrySet()) {
            Date dateParamValue = entry.getValue();
            if (dateParamValue == null) continue;
            paramValue.put(entry.getKey(), TimeUtils.format((Date)dateParamValue, (DateFormat)format));
        }
        for (Map.Entry<Integer, ListParamValue> entry : contractParameterManager.getListParamValueMap(contractId, paramIds).entrySet()) {
            listParamValue = entry.getValue();
            if (listParamValue == null) continue;
            paramValue.put(entry.getKey(), ((ListParamValue)listParamValue).toString());
        }
        for (Map.Entry<Integer, PhoneParamValue> entry : contractParameterManager.getPhoneParamMap(contractId, paramIds).entrySet()) {
            PhoneParamValue phoneParamValue = entry.getValue();
            if (phoneParamValue == null) continue;
            paramValue.put(entry.getKey(), phoneParamValue.getPhones());
        }
        for (Map.Entry<Integer, MultiListParamValues> entry : contractParameterManager.getMultiListParamValueMap(contractId, paramIds).entrySet()) {
            listParamValue = entry.getValue();
            if (listParamValue == null) continue;
            paramValue.put(entry.getKey(), ((MultiListParamValues)listParamValue).toStringValue());
        }
        contractParameterManager.close();
        return paramValue;
    }
}

