/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNotification;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNotificationService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNotificationDao;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNotificationService")
public class ContractNotificationServiceImpl
extends AbstractService
implements ContractNotificationService {
    private ContractNotificationDao contractNotificationDao;

    @PostConstruct
    void init() {
        this.contractNotificationDao = new ContractNotificationDao(this.getConnection());
    }

    @Override
    public List<ContractNotification> contractNotificationList(int contractId) throws BGException {
        return this.contractNotificationDao.list(contractId);
    }

    @Override
    public void contractNotificationDelete(int contractId, int id) throws BGException {
        ContractNotification cn = (ContractNotification)this.contractNotificationDao.get(id);
        if (cn == null || cn.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        this.contractNotificationDao.delete(id);
    }

    @Override
    public int contractNotificationUpdate(int contractId, ContractNotification contractNotification) throws BGException {
        if (contractNotification == null) {
            throw new BGIllegalArgumentException("contractNotification");
        }
        if (contractNotification.getContractId() <= 0 || contractNotification.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        this.contractNotificationDao.update((Object)contractNotification);
        return contractNotification.getId();
    }

    @Override
    public void contractNotificationMarkRead(int contractId, int id) throws BGException {
        this.contractNotificationDao.markReadNotification(contractId, id);
    }

    @Override
    public int contractNotificationUnreadCount(int contractId) {
        return this.contractNotificationDao.getUnreadNotificationsCount(contractId);
    }
}

