/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server.action;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.CostMapManager;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.common.Utils;

public class ActionCostMap
extends AbstractAction {
    public void updateItem() throws BGException {
        int costMapId = this.req.getInt("costMapId", -1);
        String code = this.req.get("code", null);
        BigDecimal cost = this.req.getBigDecimal("cost", null);
        if (costMapId <= 0 || Utils.isBlankString((String)code)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        CostMapItem item = new CostMapItem();
        item.setCode(code);
        item.setCost(cost);
        try (CostMapManager costMapManager = new CostMapManager(this.con, this.moduleId);){
            costMapManager.updateItem(costMapId, item);
        }
    }

    public void deleteItem() throws BGException {
        int costMapId = this.req.getInt("costMapId", -1);
        String code = this.req.get("code", null);
        if (costMapId <= 0 || Utils.isBlankString((String)code)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        try (CostMapManager costMapManager = new CostMapManager(this.con, this.moduleId);){
            costMapManager.deleteItem(costMapId, code);
        }
    }

    public void importMap() throws BGException {
        int costMapId = this.req.getInt("costMapId", -1);
        boolean update = this.req.getInt("update", -1) > 0;
        String prefix = this.req.get("prefix", null);
        String data = this.req.get("data", null);
        if (costMapId <= 0 || Utils.isBlankString((String)data)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        try (CostMapManager costMapManager = new CostMapManager(this.con, this.moduleId);){
            costMapManager.importMap(costMapId, data, prefix, update);
        }
    }

    public String exportMap() throws BGException {
        int costMapId = this.req.getInt("costMapId", -1);
        String code = this.req.get("code", null);
        if (costMapId <= 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        try (CostMapManager costMapManager = new CostMapManager(this.con, this.moduleId);){
            String string = costMapManager.exportMap(costMapId, code);
            return string;
        }
    }
}

