/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractTariff;
import bitel.billing.server.contract.bean.ContractTariffManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.event.events.ContractTariffUpdateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;

public class ActionUpdateContractTariffPlan
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", 0);
        int cid = this.getIntParameter("cid", -1);
        int tpid = this.getIntParameter("tpid", -1);
        int pos = this.getIntParameter("pos", 0);
        int entityMid = this.getIntParameter("entityMid", 0);
        int entityId = this.getIntParameter("entityId", 0);
        Calendar date1 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date1"));
        Calendar date2 = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date2"));
        String comment = this.getParameter("comment");
        if (id < 0 || cid == -1 || tpid == -1) {
            throw new BGIllegalArgumentException();
        }
        TimeUtils.checkPeriod((Date)this.getDateParameter("date1"), (Date)this.getDateParameter("date2"));
        boolean isAdd = id == 0;
        ContractTariffManager contractTariffManager = new ContractTariffManager(this.con);
        ContractTariff contractTariff = new ContractTariff();
        contractTariff.setId(id);
        contractTariff.setContractId(cid);
        contractTariff.setTariffPlanId(tpid);
        contractTariff.setPos(pos);
        contractTariff.setDate1(date1);
        contractTariff.setDate2(date2);
        contractTariff.setComment(comment);
        contractTariff.setEntityMid(entityMid);
        contractTariff.setEntityId(entityId);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdateContractTariffPlan", this.mid, this.userId);
        if (closedDate != null) {
            ContractTariff old = contractTariffManager.getContractTariffById(id);
            Calendar olddate1 = null;
            Calendar olddate2 = null;
            if (old != null) {
                olddate1 = old.getDate1();
                olddate2 = old.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate(closedDate, olddate1, olddate2, date1, date2);
            if (old != null && contractTariff.getTariffPlanId() != old.getTariffPlanId()) {
                ClosedDateChecker.checkDatesForUpdate(closedDate, olddate1, new GregorianCalendar());
            }
        }
        contractTariffManager.updateContractTariff(contractTariff);
        this.context.publishAfterCommit(new ContractTariffChangedEvent(cid));
        this.context.publishAfterCommit(new ContractTariffUpdateEvent((int)this.userId, cid, contractTariff, isAdd));
    }
}

