/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class VlanResourceSubscriptionPanel
extends BGUPanel {
    private VlanResource current = null;
    private BGControlPanelPages pages;
    private BGControlPanelPeriodNoB period;
    private VlanResourceSubscriptionTableModel model = new VlanResourceSubscriptionTableModel();

    public VlanResourceSubscriptionPanel() {
        super(new BorderLayout(0, 0));
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        this.period = new BGControlPanelPeriodNoB();
        this.pages = new BGControlPanelPages();
        BGSwingUtilites.handleRefresh(this, this.period, this.pages);
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add((Component)this.period, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        topPanel.add((Component)this.pages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        BGSwingUtilites.buildPopupMenu(table, (Container)this, "vlanResourceSubscription");
        this.add((Component)topPanel, "North");
        this.add((Component)new JScrollPane(table), "Center");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.MenuAction("vlanResourceSubscription.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetServ serv;
                VlanResourceSubscription vlanResourceSubscription = (VlanResourceSubscription)e.getSource();
                if (vlanResourceSubscription != null && (serv = ((ClientContext)VlanResourceSubscriptionPanel.this.getContext()).getPort(InetServService.class).inetServGet(vlanResourceSubscription.getSubscriberId())) != null) {
                    VlanResourceSubscriptionPanel.this.openContract(serv.getContractId());
                }
            }
        };
        new AbstractBGUPanel.AsyncAction<Result<VlanResourceSubscription>>("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            protected Result<VlanResourceSubscription> doInBackground() throws Exception {
                Result result = ((ClientContext)VlanResourceSubscriptionPanel.this.getContext()).getPort(ResourceService.class).vlanSubscriptionList(VlanResourceSubscriptionPanel.this.current.getId(), VlanResourceSubscriptionPanel.this.period.getDateFrom(), VlanResourceSubscriptionPanel.this.period.getDateTo(), VlanResourceSubscriptionPanel.this.pages.getPage());
                VlanResourceSubscriptionPanel.this.pages.setPage(result.getPage());
                return result;
            }

            @Override
            protected void done(Result<VlanResourceSubscription> result) throws Exception {
                VlanResourceSubscriptionPanel.this.model.setData(result.getList());
            }
        };
        new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ((BGEditor)VlanResourceSubscriptionPanel.this.getParent().getParent()).show("table");
            }
        };
    }

    public void setVlanResource(VlanResource vlanResource) {
        this.current = vlanResource;
    }

    class VlanResourceSubscriptionTableModel
    extends BGTableModel<VlanResourceSubscription> {
        public VlanResourceSubscriptionTableModel() {
            super(VlanResourceSubscriptionTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("VLAN", DeviceGroup.class, 150, 150, 150, "vlan", false, false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, 180, 180, 180, null, false, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a", String.class, -1, 120, -1, "subscriberTitle", false, false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(VlanResourceSubscription val, int column) throws BGException {
            switch (column) {
                case 2: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }
}

