/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree.zone;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class NZoneTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("eath");
    private JPanel propsPanel;
    private JLabel view = new JLabel();
    private BGComboBox<IdTitle> zoneCombo;
    private Directory zoneDir;
    private String zoneTitle;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.view.setIcon(icon);
        this.zoneDir = this.getDirManager().getDirectory("zones");
    }

    private void createPropsPanel() {
        this.propsPanel = new JPanel();
        this.propsPanel.add(new JLabel(this.getLabelTitle()));
        this.zoneCombo = new BGComboBox();
        this.buildDirectoryCombo(this.zoneDir, this.zoneCombo);
        this.propsPanel.add(this.zoneCombo);
        this.propsPanel.add(this.getDirectoryAddPanel(this.zoneDir, this.zoneCombo, false));
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public void setData(String data) {
        super.setData(data);
        this.updateView();
    }

    private void updateView() {
        StringBuffer str = new StringBuffer();
        this.extractData();
        if (Utils.notBlankString(this.zoneTitle)) {
            str.append(this.getLabelTitle());
            str.append(this.zoneTitle);
        }
        this.view.setText(str.toString());
    }

    @Override
    protected void loadData() {
        Map<String, String> data;
        String zone;
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        if ((zone = (data = this.getDataInHash()).get("zone")) == null) {
            zone = "0";
        }
        this.setDirectoryItemSelection(this.zoneCombo, Utils.parseInt(zone, 0));
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        IdTitle di = this.zoneCombo.getSelectedItem();
        if (di != null) {
            data.put("zone", String.valueOf(di.getId()));
        }
        this.setDataInHash(data);
        this.updateView();
    }

    public void extractData() {
        Map<String, String> data = this.getDataInHash();
        String zone = data.get("zone");
        if (zone == null) {
            zone = "0";
        }
        if (this.zoneDir != null && !zone.equals("0")) {
            this.zoneTitle = this.zoneDir.getValue(Utils.parseInt(zone, 0));
        }
    }

    @Override
    protected JPanel getEditorPanel() {
        if (this.propsPanel == null) {
            this.createPropsPanel();
        }
        return this.propsPanel;
    }

    @Override
    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        this.extractData();
        if (Utils.notEmptyString(this.zoneTitle)) {
            el.setAttribute("zone", this.zoneTitle);
        }
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        HashMap<String, String> data = new HashMap<String, String>(3);
        String zoneTitle = el.getAttribute("zone");
        if (Utils.notBlankString(zoneTitle)) {
            int zoneCode = this.zoneDir.getCode(zoneTitle);
            if (zoneCode <= 0) {
                zoneCode = this.zoneDir.addValue(zoneTitle);
            }
            data.put("zone", String.valueOf(zoneCode));
        }
        this.setDataInHash(data);
        this.saveData();
        this.updateView();
        this.loadChildsFromXML(el);
    }

    protected String getLabelTitle() {
        return "\u0417\u043e\u043d\u0430: ";
    }
}

