/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.nas;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bsh.EvalError;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptInstance;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public abstract class NasScriptInvoker {
    private static final Logger logger = LogManager.getLogger();

    public Object processRequest(RadiusPacket request, RadiusPacket response, Connection con, Connection conSlave, DefaultServerSetup setup) {
        try {
            return this.processRequestImpl(request, response, con, conSlave, setup);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            String key = "radius.request.preprocess";
            long time = System.currentTimeMillis();
            if (AlarmSender.needAlarmSend((String)key, (long)time, (long)10L)) {
                String message = "\u0417\u0430\u043f\u0440\u043e\u0441:" + request.toString();
                AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430 \u043f\u0440\u0435\u0434\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 RADIUS \u0437\u0430\u043f\u0440\u043e\u0441\u0430", message, e), (long)time);
            }
            return null;
        }
    }

    protected abstract Object processRequestImpl(RadiusPacket var1, RadiusPacket var2, Connection var3, Connection var4, DefaultServerSetup var5) throws EvalError;

    static final class Invoker
    extends NasScriptInvoker {
        private final ScriptInstance instance;
        private final String method;

        Invoker(ScriptInstance instance, String method) {
            this.instance = instance;
            this.method = method;
        }

        @Override
        public Object processRequestImpl(RadiusPacket request, RadiusPacket response, Connection con, Connection conSlave, DefaultServerSetup setup) throws EvalError {
            Object result = null;
            result = this.instance.invoke(this.method, new Object[]{request, response, setup, con, conSlave});
            logger.info("REQUEST_AFTER_SCRIPT:\n" + request.toString());
            return result;
        }
    }
}

