/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.eap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;

public class EAPMessage {
    public static final int EAP_HEADER_LENGTH = 5;
    public static final byte CODE_REQUEST = 1;
    public static final byte CODE_RESPONSE = 2;
    public static final byte CODE_SUCCESS = 3;
    public static final byte CODE_FAILURE = 4;
    public static final byte TYPE_IDENTITY = 1;
    public static final byte TYPE_NOTIFICATION = 2;
    public static final byte TYPE_NAK = 3;
    public static final byte TYPE_MD5CHALLENGE = 4;
    public static final byte TYPE_ONETYPEPASSWORD = 5;
    public static final byte TYPE_GENERICTOKENCARD = 6;
    public static final byte TYPE_RSA_PUBLIC_KEY_AUTH = 9;
    public static final byte TYPE_EAP_TLS = 13;
    public static final byte TYPE_EAP_LEAP = 17;
    public static final byte TYPE_SRP_SHA1 = 19;
    public static final byte TYPE_SRP_SHA2 = 20;
    public static final byte TYPE_EAP_TTLS = 21;
    public static final byte TYPE_PEAP = 25;
    public static final byte TYPE_EAP_MSCHAP_V2 = 26;
    public static final byte TYPE_EAP_TLV = 33;
    public final byte code;
    public final byte identifier;
    public final byte type;
    private final ByteBuffer data;
    private static final int EAP_ATTRIBUTE_LENGHT = 253;

    public EAPMessage(byte code, byte identifier, byte type, ByteBuffer data) {
        this.code = code;
        this.identifier = identifier;
        this.type = type;
        this.data = data;
    }

    public ByteBuffer getData() {
        this.data.clear();
        return this.data.asReadOnlyBuffer();
    }

    public static EAPMessage newEAPMessage(RadiusPacket packet) {
        List<RadiusAttribute<?>> eap = packet.getAttributes(-1, 79);
        if (eap != null) {
            ByteBuffer data;
            byte type;
            RadiusAttribute<?> ra = eap.get(0);
            ByteBuffer bb = ra.getData();
            byte code = bb.get();
            byte identifier = bb.get();
            if (code == 1 || code == 2) {
                int length = bb.getShort() & 0xFFFF;
                type = bb.get();
                data = ByteBuffer.allocate(length - 5);
                data.put(bb);
                int size = eap.size();
                for (int i = 1; i < size; ++i) {
                    ra = eap.get(i);
                    bb = ra.getData();
                    data.put(bb);
                }
            } else {
                type = 0;
                data = null;
            }
            return new EAPMessage(code, identifier, type, data);
        }
        return null;
    }

    public static void toByteBuffer(ByteBuffer bb, byte code, byte identifier, byte type, ByteBuffer data) {
        int length = 5;
        if (data != null) {
            length = (short)(length + data.capacity());
        }
        bb.put(code);
        bb.put(identifier);
        bb.putShort((short)(length & 0xFFFF));
        bb.put(type);
        if (data != null) {
            data.clear();
            bb.put(data);
        }
    }

    public static byte[] toByteArray(byte code, byte identifier, byte type, ByteBuffer data) {
        int length = 5;
        if (data != null) {
            length = (short)(length + data.capacity());
        }
        byte[] result = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.put(code);
        bb.put(identifier);
        bb.putShort((short)(length & 0xFFFF));
        bb.put(type);
        if (data != null) {
            data.clear();
            bb.put(data);
        }
        return result;
    }

    public void toByteBuffer(ByteBuffer bb) {
        EAPMessage.toByteBuffer(bb, this.code, this.identifier, this.type, this.data);
    }

    public byte[] toByteArray() {
        return EAPMessage.toByteArray(this.code, this.identifier, this.type, this.data);
    }

    public void toPEAPv0ByteBuffer(ByteBuffer bb) {
        int length = 1;
        if (this.data != null) {
            length = (short)(length + this.data.capacity());
        }
        bb.put(this.type);
        if (this.data != null) {
            this.data.clear();
            bb.put(this.data);
        }
    }

    public byte[] toPEAPv0ByteArray() {
        int length = 1;
        if (this.data != null) {
            length = (short)(length + this.data.capacity());
        }
        byte[] result = new byte[length];
        ByteBuffer bb = ByteBuffer.wrap(result);
        bb.put(this.type);
        if (this.data != null) {
            this.data.clear();
            bb.put(this.data);
        }
        return result;
    }

    public List<RadiusAttribute<?>> toRadiusAttributes() {
        ArrayList result = new ArrayList();
        int length = (this.data != null ? this.data.capacity() : 0) + 5;
        ByteBuffer bb = ByteBuffer.allocate(Math.min(length, 253));
        bb.put(this.code);
        bb.put(this.identifier);
        bb.putShort((short)(length & 0xFFFF));
        bb.put(this.type);
        if (this.code == 1 || this.code == 2) {
            this.data.clear();
            this.data.limit(bb.remaining());
            bb.put(this.data);
            assert (this.data.hasRemaining() == bb.hasRemaining());
            bb.rewind();
            result.add(new RadiusAttribute(-1, 79, bb));
            this.data.limit(Math.min(this.data.capacity(), this.data.position() + 253));
            while (this.data.hasRemaining()) {
                bb = ByteBuffer.allocate(Math.min(this.data.remaining(), 253));
                bb.put(this.data);
                bb.rewind();
                result.add(new RadiusAttribute(-1, 79, bb));
                this.data.limit(Math.min(this.data.capacity(), this.data.position() + 253));
            }
        } else {
            bb.rewind();
            result.add(new RadiusAttribute(-1, 79, bb));
        }
        return result;
    }
}

