/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.IPFIXRecord;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;
import ru.bitel.common.Utils;

public class IPFIXArray
extends FlowArray<IPFIXRecord>
implements Netflow9Processor {
    private static final Logger log = LogManager.getLogger();

    public IPFIXArray(int size) {
        super(IPFIXArray.create(size));
    }

    private static final List<IPFIXRecord> create(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(String.valueOf(size));
        }
        ArrayList<IPFIXRecord> recordList = new ArrayList<IPFIXRecord>(size);
        for (int i = 0; i < size; ++i) {
            recordList.add(new IPFIXRecord());
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean parsePacket(ByteBuffer readBuffer, long millis, ConcurrentMap<Integer, NetFlow9Template> templates) {
        int bufferPosition = readBuffer.position();
        try {
            this.size = 0;
            int version = readBuffer.getShort(0) & 0xFFFF;
            int length = readBuffer.getShort(2) & 0xFFFF;
            if (version != 10) {
                log.error("Incorrect IPFIX version: " + version);
                boolean bl = false;
                return bl;
            }
            int packetLimit = readBuffer.limit();
            if (log.isTraceEnabled()) {
                log.trace("IPFIX packet, len: " + length + "; limit: " + packetLimit);
            }
            int offset = 16;
            int i = 0;
            while (offset < packetLimit) {
                NetFlow9Template template;
                int templateId;
                readBuffer.position(offset);
                int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                int flowSetLimit = offset + flowSetLength;
                if (log.isTraceEnabled()) {
                    log.trace("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; limit: " + flowSetLimit);
                }
                if (flowSetId > 255) {
                    log.trace("Data flowset.");
                    templateId = flowSetId;
                    template = (NetFlow9Template)templates.get(templateId);
                    if (template != null) {
                        offset += 4;
                        if (log.isTraceEnabled()) {
                            log.trace("Template data length: " + template.dataLength);
                        }
                        while (offset + template.minDataLength <= flowSetLimit) {
                            if (template.flowLog) {
                                readBuffer.position(offset);
                                IPFIXRecord record = ((IPFIXRecord[])this.array)[this.size];
                                int len = record.fillData(readBuffer, template);
                                record.milliseconds = millis;
                                if (log.isTraceEnabled()) {
                                    log.trace("Record: " + this.size + "; offset: " + offset + "\n" + record);
                                }
                                ++this.size;
                                offset += len;
                                continue;
                            }
                            if (log.isTraceEnabled()) {
                                log.trace("Not flow record");
                            }
                            offset += template.skipData(readBuffer, offset);
                        }
                    }
                } else if (flowSetId == 2) {
                    if (log.isTraceEnabled()) {
                        log.trace("Template flowset!");
                    }
                    offset += 4;
                    while (offset < flowSetLimit) {
                        templateId = readBuffer.getShort(offset) & 0xFFFF;
                        template = new NetFlow9Template();
                        readBuffer.position(offset);
                        template.parse(readBuffer);
                        templates.put(templateId, template);
                        offset += template.length;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Offset: " + offset);
                    }
                }
                offset = flowSetLimit;
                ++i;
            }
        }
        finally {
            readBuffer.position(bufferPosition);
        }
        return true;
    }

    public final int next(ByteBuffer readBuffer, ConcurrentMap<Integer, NetFlow9Template> templates) throws Exception {
        this.size = 0;
        return IPFIXArray.next(readBuffer, templates, this);
    }

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) {
        if (!template.flowLog) {
            return;
        }
        readBuffer.position(offset);
        IPFIXRecord record = ((IPFIXRecord[])this.array)[this.size];
        record.fillData(readBuffer, template);
        record.milliseconds = millis;
        if (log.isTraceEnabled()) {
            log.trace("Record: " + this.size + "; offset: " + offset + "\n" + record);
        }
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int next(ByteBuffer readBuffer, ConcurrentMap<Integer, NetFlow9Template> templates, Netflow9Processor processor) throws Exception {
        int offset = readBuffer.position();
        int limit = readBuffer.limit() - 1;
        try {
            while (offset < limit) {
                long millis = readBuffer.getLong(offset);
                int packetLength = readBuffer.getInt(offset + 12);
                int packetEnd = (offset += 16) + packetLength;
                int version = readBuffer.getShort(offset) & 0xFFFF;
                int len = readBuffer.getShort(offset + 2) & 0xFFFF;
                if (version != 10) {
                    log.error("Incorrect IPFIX version: " + version);
                }
                if (log.isTraceEnabled()) {
                    log.trace("IPFIX packet, len: " + len);
                }
                offset += 16;
                while (offset < packetEnd) {
                    NetFlow9Template template;
                    int templateId;
                    readBuffer.position(offset);
                    int flowSetId = readBuffer.getShort(offset) & 0xFFFF;
                    int flowSetLength = readBuffer.getShort(offset + 2) & 0xFFFF;
                    int flowSetEnd = offset + flowSetLength;
                    if (log.isTraceEnabled()) {
                        log.trace("FlowSet id: " + flowSetId + "; offset: " + offset + "; length: " + flowSetLength + "; end: " + flowSetEnd);
                    }
                    if (flowSetId > 255) {
                        log.trace("Data flowset.");
                        templateId = flowSetId;
                        template = (NetFlow9Template)templates.get(templateId);
                        if (template != null) {
                            offset += 4;
                            if (log.isTraceEnabled()) {
                                log.trace("Template data length: " + template.dataLength);
                            }
                            while (offset + template.minDataLength <= flowSetEnd) {
                                processor.process(readBuffer, offset, millis, template);
                                offset += template.skipData(readBuffer, offset);
                            }
                        }
                    } else if (flowSetId == 2) {
                        if (log.isTraceEnabled()) {
                            log.trace("Template flowset!");
                        }
                        readBuffer.position(offset);
                        offset += 4;
                        while (offset < flowSetEnd) {
                            templateId = readBuffer.getShort(offset) & 0xFFFF;
                            template = new NetFlow9Template();
                            readBuffer.position(offset);
                            template.parse(readBuffer);
                            templates.put(templateId, template);
                            offset += template.length;
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("Offset: " + offset);
                        }
                    }
                    offset = flowSetEnd;
                }
                offset = packetEnd;
            }
        }
        finally {
            readBuffer.position(offset);
        }
        return offset;
    }

    public static void main(String[] args) {
        byte[] ipfixTemplate = Utils.stringToBytes("000a01285c63b6b100066788000000000002011801020023003c00010016000400150004000200040001000400070002000b0002000a0004000e000400040001000500010006000100500006005100060038000600080004000c0004000f000400090001000d000100c0000100ce000100bd000100e0000800cd000200b8000400b9000400ba00020021000100b0000100b1000100e1000400e2000400e3000200e4000201030020003c00010016000400150004000200040001000400070002000b0002000a0004000e0004000400010005000100060001005000060051000600380006001b0010001c0010003e0010001d0001001e000100c0000100ce000100bd000100e0000800cd000200b8000400b9000400ba00020021000100b2000100b30001001f0004", null);
        byte[] ipfix = Utils.stringToBytes("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", null);
        ConcurrentHashMap<Integer, NetFlow9Template> templates = new ConcurrentHashMap<Integer, NetFlow9Template>();
        IPFIXArray array = new IPFIXArray(60);
        array.parsePacket(ByteBuffer.wrap(ipfixTemplate), System.currentTimeMillis(), templates);
        System.out.println(templates.size());
        array.parsePacket(ByteBuffer.wrap(ipfix), System.currentTimeMillis(), templates);
        System.out.println(array.size);
    }
}

