/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.api.common;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItemModifiedEvent;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.model.IdTitle;

public abstract class ReferenceValueDirectory<K extends IdTitle, V> {
    private static final Logger log = LogManager.getLogger();
    private final ConcurrentMap<Integer, AtomicReference<V>> map = new ConcurrentHashMap<Integer, AtomicReference<V>>();

    public ReferenceValueDirectory(boolean realtime, Connection con, final int moduleId, final Class<K> clazz) throws BGException {
        final DirectoryItem directoryItem = clazz.getAnnotation(DirectoryItem.class);
        if (directoryItem == null) {
            throw new IllegalArgumentException("Annotation DirectoryItem not found!");
        }
        if (realtime) {
            new Thread("ReferenceValueDirectory-init"){

                @Override
                public void run() {
                    try {
                        EventProcessor.getInstance().addListener(new ModifiedListener(clazz, moduleId), directoryItem.eventClass(), moduleId, null);
                    }
                    catch (BGException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }.start();
        }
    }

    protected void onUpdate(Connection con, int moduleId, List<K> list) throws BGException {
        this.onUpdate(list);
    }

    protected void onUpdate(List<K> list) throws BGException {
    }

    protected void init(Connection con, int moduleId, Class<K> clazz) throws BGException {
        Directory<K> directory = ServerDirectoryFactory.newDirectory(null, clazz, con, moduleId, false);
        List<K> list = directory.list();
        this.onUpdate(con, moduleId, list);
        this.directoryUpdate(con, moduleId, this.map, list);
    }

    protected V newValue(Connection con, int moduleId, K value) {
        return this.newValue(value);
    }

    protected abstract V newValue(K var1);

    private void directoryUpdate(Connection con, int moduleId, ConcurrentMap<Integer, AtomicReference<V>> map, List<K> list) throws BGException {
        for (IdTitle k : list) {
            V newValue = this.newValue(con, moduleId, k);
            AtomicReference<V> ref = (AtomicReference<V>)map.get(k.getId());
            if (ref == null) {
                AtomicReference<V> newRef = new AtomicReference<V>(newValue);
                ref = map.putIfAbsent(k.getId(), newRef);
                if (ref == null) {
                    ref = newRef;
                    continue;
                }
                ref.set(newValue);
                continue;
            }
            ref.set(newValue);
        }
    }

    public V get(int id) throws BGException {
        AtomicReference ref = (AtomicReference)this.map.get(id);
        return ref != null ? (V)ref.get() : null;
    }

    public AtomicReference<V> getRef(int id) {
        return (AtomicReference)this.map.get(id);
    }

    public List<V> list() {
        ArrayList result = new ArrayList();
        for (AtomicReference ref : this.map.values()) {
            Object v = ref.get();
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    final class ModifiedListener
    implements EventListener<DirectoryItemModifiedEvent<?>> {
        final Class<K> clazz;
        final int moduleId;

        public ModifiedListener(Class<K> clazz, int moduleId) {
            this.clazz = clazz;
            this.moduleId = moduleId;
        }

        @Override
        public void notify(DirectoryItemModifiedEvent<?> e, EventListenerContext ctx) throws BGException {
            if (this.moduleId == e.getModuleId()) {
                log.info("Reinit directory moduleId:" + this.moduleId + "; class: " + this.clazz.getName());
                ReferenceValueDirectory.this.init(ctx.getConnection(), this.moduleId, this.clazz);
            }
        }

        public String toString() {
            return "Directory" + this.clazz.getSimpleName() + "ModifiedListener@" + System.identityHashCode(this);
        }
    }
}

