/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.bean.Writable;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class PatternPluginTabPanel
extends PatternBaseTabPanel {
    private static String NOT_PANEL = "not";
    private Collection<PatternPluginTabPanelItem> pluginTabPanelItems = new ArrayList<PatternPluginTabPanelItem>();
    private JPanel tabbed = new JPanel();
    private CardLayout tabbedLayout = new CardLayout();
    private JList<IdTitle> pluginList = new JList(new DefaultListModel());
    private List<IdTitle> allModulesMap = new ArrayList<IdTitle>();

    public PatternPluginTabPanel(Document moduleDoc) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.tabbed.setLayout(this.tabbedLayout);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.add((Component)new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbed.add((Component)panel1, NOT_PANEL);
        this.loadModules();
        JSplitPane split = new JSplitPane(1, this.getPluginPanel(), this.tabbed);
        split.setDividerSize(5);
        split.setDividerLocation(250);
        this.setLayout(new GridBagLayout());
        this.add((Component)split, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JPanel getPluginPanel() {
        JPanel pluginPanel = new JPanel();
        pluginPanel.setLayout(new GridBagLayout());
        pluginPanel.add((Component)new JScrollPane(this.pluginList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.pluginList.addListSelectionListener(e -> this.showConfigPanel());
        return pluginPanel;
    }

    private void rebuildList() {
        DefaultListModel model = (DefaultListModel)this.pluginList.getModel();
        model.removeAllElements();
        for (IdTitle module : this.allModulesMap) {
            model.addElement(module);
        }
    }

    public void loadModules() {
        HashMap<String, Element> cache = new HashMap<String, Element>();
        this.allModulesMap.clear();
        Request req = new Request();
        req.setModule("service");
        req.setAction("Plugins");
        Document doc = this.getDocument(req);
        Element data = XMLUtils.selectElement(doc, "//plugins");
        NodeList nodeList = data.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Element el = (Element)node;
            int pid = Utils.parseInt(el.getAttribute("uid"), -1);
            String title = el.getAttribute("title");
            String pkg = el.getAttribute("id");
            IdTitle plugin = new IdTitle(pid, title);
            this.allModulesMap.add(plugin);
            JTabbedPane panel = new JTabbedPane();
            panel.setVisible(false);
            boolean add = false;
            try {
                Class<?> clazz = Class.forName(pkg + ".client.PatternPluginTabPanelItemFactory");
                if (clazz == null || !PatternPluginTabPanelItemFactory.class.isAssignableFrom(clazz)) continue;
                PatternPluginTabPanelItemFactory f = (PatternPluginTabPanelItemFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (PatternPluginTabPanelItem o : f.getPatternPluginTabPanelItems(pid, title)) {
                    this.pluginTabPanelItems.add(o.init(cache, this));
                    panel.add((Component)o, o.getTitle());
                    if (add) continue;
                    this.tabbed.add((Component)panel, title);
                    add = true;
                }
                continue;
            }
            catch (ClassNotFoundException clazz) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setData(Document doc) {
    }

    @Override
    public void setPatternData(Element pattern) {
        for (PatternPluginTabPanelItem i : this.pluginTabPanelItems) {
            i.setData(pattern);
        }
        this.rebuildList();
    }

    @Override
    public void resetData() {
        for (PatternPluginTabPanelItem i : this.pluginTabPanelItems) {
            i.reset();
        }
    }

    @Override
    public boolean setRequestData(Request request) {
        Document doc = XMLUtils.newDocument();
        final Element plugins = doc.createElement("plugins");
        for (PatternPluginTabPanelItem i : this.pluginTabPanelItems) {
            i.serialise(plugins);
        }
        request.setAttribute("plugins", new Writable(Writer.class){

            @Override
            public void write(Object w) throws IOException {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer serializer = tf.newTransformer();
                    serializer.setOutputProperty("encoding", "UTF-8");
                    serializer.setOutputProperty("indent", "yes");
                    serializer.transform(new DOMSource(plugins), new StreamResult((Writer)w));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    private void showConfigPanel() {
        this.tabbedLayout.show(this.tabbed, NOT_PANEL);
        IdTitle item = this.pluginList.getSelectedValue();
        if (item != null) {
            this.tabbedLayout.show(this.tabbed, item.getTitle());
        }
    }

    public static interface PatternPluginTabPanelItemFactory {
        public Collection<PatternPluginTabPanelItem> getPatternPluginTabPanelItems(int var1, String var2);
    }

    public static abstract class PatternPluginTabPanelItem
    extends JPanel {
        protected int pid;
        protected Map<String, Element> cache;
        protected PatternPluginTabPanel patternPluginTabPanel;

        public PatternPluginTabPanelItem(LayoutManager layout) {
            super(layout);
        }

        protected final PatternPluginTabPanelItem init(Map<String, Element> cache, PatternPluginTabPanel patternPluginTabPanel) {
            this.cache = cache;
            this.patternPluginTabPanel = patternPluginTabPanel;
            this.init();
            return this;
        }

        protected abstract void init();

        protected Document getDocument(Request request) {
            return this.patternPluginTabPanel.getDocument(request);
        }

        protected void initBGPanel(BGPanel panel, String module, int mid) {
            panel.init(module, mid);
        }

        protected boolean checkStatus(Document doc) {
            return ClientUtils.checkStatus(doc);
        }

        public int getPid() {
            return this.pid;
        }

        protected abstract boolean isItemEnabled();

        protected abstract void setData(Element var1);

        protected abstract void reset();

        protected abstract void serialise(Element var1);

        public abstract String getTitle();
    }

    public static interface PatternPluginTabPanelItemParams {
        public void serializeParams(Element var1);

        public void setParams(Element var1);

        public void initParams(int var1);
    }
}

