/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import bitel.billing.module.admin.DialogContractSelect;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.CalendarDialog;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.contract.AddressEditor;
import bitel.billing.module.contract.ContractParameterTableRow;
import bitel.billing.module.contract.ContractSubPanel_Parameters;
import bitel.billing.module.contract.ContractTabbedPane;
import bitel.billing.module.contract.EmailEditor;
import bitel.billing.module.contract.ListParamEditor;
import bitel.billing.module.contract.MultiListParamEditor;
import bitel.billing.module.contract.ParameterEditor;
import bitel.billing.module.contract.PhoneEditor;
import bitel.billing.module.contract.ServiceEditor;
import bitel.billing.module.contract.TableContractParameters;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerParamPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class ContractParamPanel
extends BGPanel {
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_MODE = "contract.parameters.mode";
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_FILLED = "contract.parameters.filled";
    private static final String PARAM_KEY_CONTRACT_PARAMETERS_FILTER = "contract.parameters.filter";
    private boolean isGet = false;
    private boolean initCopyPanle = false;
    private boolean initHistoryPanel = false;
    private ButtonActions buttonActions = new ButtonActions();
    private AddressEditor addressEditor;
    private ServiceEditor serviceEditor;
    private EmailEditor emailEditor;
    private ListParamEditor listEditor;
    private MultiListParamEditor multiListEditor;
    private PhoneEditor phoneEditor;
    private JPanel tablePanel = null;
    private CardLayout tableLayout = new CardLayout();
    private CardLayout editorLayout = new CardLayout();
    private JPanel editorContainer = new JPanel();
    private JPanel editorPanel = new JPanel();
    private JComboBox<ComboBoxItem> groups = new BGComboBox<ComboBoxItem>();
    private BGButtonPanelRestoreOkCancelHelp bgButtonPanel;
    private HistoryTableModel historyTableModel = new HistoryTableModel(HistoryTableModel.class.getName());
    private BGControlPanelListSelect paramList = null;
    private TableContractParameters tableContractParameters = new TableContractParameters();
    private TitleJList contractPanel = null;
    private TitleJList patternPanel = null;
    private JToggleButton filledButton = null;
    private JToggleButton typesButton = null;
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private ButtonGroup buttonGroupParam = null;
    private JPanel extPanel = new JPanel(new GridBagLayout());
    private int selectedPid = 0;
    private int selectedPt = 0;
    private Document parametersDocument = null;
    private ClientSetup clientSetup = ClientSetup.getInstance();
    private CustomerParamPanel customerParamPanel = new CustomerParamPanel();

    public ContractParamPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tableContractParameters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ContractParamPanel.this.tableContract_mouseClicked(e);
            }
        });
        this.tableContractParameters.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doEnterEditing");
        this.tableContractParameters.getActionMap().put("doEnterEditing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractParamPanel.this.tableContract_enterPressed();
            }
        });
        ((DefaultTableModel)this.tableContractParameters.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ContractParamPanel.this.fl && ContractParamPanel.this.tableContractParameters.getRowCount() > 0) {
                    int n = e.getFirstRow();
                    ContractParameterTableRow row = (ContractParameterTableRow)ContractParamPanel.this.tableContractParameters.getValueAt(n, 0);
                    String pt = String.valueOf(row.getParameterType());
                    String pid = String.valueOf(row.getParameterId());
                    Object value = ContractParamPanel.this.tableContractParameters.getValueAt(n, 1);
                    if ("1".equals(pt)) {
                        ContractParamPanel.this.updateParameter("UpdateParameterType1", pt, pid, value, n);
                        EventBus.publish((Object)new UpdateContractTreeEvent(ContractParamPanel.this.getModuleId(), ContractParamPanel.this.getContractId()));
                    } else if ("5".equals(pt)) {
                        ContractParamPanel.this.updateParameter("UpdateParameterType5", pt, pid, value, n);
                        EventBus.publish((Object)new UpdateContractTreeEvent(ContractParamPanel.this.getModuleId(), ContractParamPanel.this.getContractId()));
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.tablePanel = new JPanel(this.tableLayout);
        this.tablePanel.add((Component)this.getParamPanel(), "param");
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.customerParamPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tablePanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getParamPanel() {
        this.editorContainer.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.tableContractParameters), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.editorContainer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void initHistoryPanel() {
        BGButton deleteHistory = new BGButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
        deleteHistory.addActionListener(e -> this.clearContractHistory());
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(new BGUTable(this.historyTableModel)), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)deleteHistory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)returnButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePanel.add((Component)panel, "history");
        this.initHistoryPanel = true;
    }

    private JPanel getButtonPanel() {
        String contractParametersMode = this.clientSetup.getUserConfig().get(PARAM_KEY_CONTRACT_PARAMETERS_MODE, "group");
        boolean contractParametersFilled = this.clientSetup.getUserConfig().getBoolean(PARAM_KEY_CONTRACT_PARAMETERS_FILLED, false);
        String contractParametersFilter = this.clientSetup.getUserConfig().get(PARAM_KEY_CONTRACT_PARAMETERS_FILTER, "");
        ActionListener buttonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String actionCommand = event.getActionCommand();
                if ("all".equals(actionCommand) || "group".equals(actionCommand)) {
                    ContractParamPanel.this.clientSetup.getUserConfig().set(ContractParamPanel.PARAM_KEY_CONTRACT_PARAMETERS_MODE, actionCommand);
                } else if ("filled".equals(actionCommand)) {
                    ContractParamPanel.this.clientSetup.getUserConfig().set(ContractParamPanel.PARAM_KEY_CONTRACT_PARAMETERS_FILLED, String.valueOf(ContractParamPanel.this.filledButton.isSelected()));
                } else if (ContractParamPanel.this.typesButton.isSelected()) {
                    ContractParamPanel.this.clientSetup.getUserConfig().set(ContractParamPanel.PARAM_KEY_CONTRACT_PARAMETERS_FILTER, actionCommand);
                }
                ContractParamPanel.this.clientSetup.saveUserConfig();
                if (ContractParamPanel.this.parametersDocument == null || "all".equals(actionCommand) || "group".equals(actionCommand)) {
                    ContractParamPanel.this.setData();
                } else {
                    ContractParamPanel.this.setDocument(ContractParamPanel.this.parametersDocument);
                }
            }
        };
        JToggleButton allParamsButton = new JToggleButton("\u0432\u0441\u0435");
        allParamsButton.setActionCommand("all");
        allParamsButton.addActionListener(buttonActionListener);
        allParamsButton.setSelected(allParamsButton.getActionCommand().equals(contractParametersMode));
        this.buttonGroup2.add(allParamsButton);
        JToggleButton groupParamsButton = new JToggleButton("\u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b", true);
        groupParamsButton.setActionCommand("group");
        groupParamsButton.addActionListener(buttonActionListener);
        groupParamsButton.setSelected(groupParamsButton.getActionCommand().equals(contractParametersMode));
        this.buttonGroup2.add(groupParamsButton);
        this.filledButton = new JToggleButton("\u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0435");
        this.filledButton.setActionCommand("filled");
        this.filledButton.addActionListener(buttonActionListener);
        this.filledButton.setSelected(contractParametersFilled);
        this.typesButton = new JToggleButton("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0442\u0438\u043f\u0430\u043c");
        this.typesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ContractParamPanel.this.clientSetup.getUserConfig().set(ContractParamPanel.PARAM_KEY_CONTRACT_PARAMETERS_FILTER, "");
                ContractParamPanel.this.clientSetup.saveUserConfig();
                ContractParamPanel.this.extPanel.setVisible(((JToggleButton)event.getSource()).isSelected());
                ContractParamPanel.this.setDocument(ContractParamPanel.this.parametersDocument);
            }
        });
        this.typesButton.setSelected(!contractParametersFilter.isEmpty());
        this.extPanel.setVisible(!contractParametersFilter.isEmpty());
        this.groups.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContractParamPanel.this.groups_itemStateChanged(e);
            }
        });
        TypeToggleButton textButton = new TypeToggleButton("\u0442\u0435\u043a\u0441\u0442", "\u041f\u0430\u043f\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0442\u0435\u043a\u0441\u0442", "1", contractParametersFilter, buttonActionListener);
        textButton.setSelected(true);
        TypeToggleButton phoneButton = new TypeToggleButton("\u0442\u0435\u043b\u0435\u0444\u043e\u043d", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d", "9", contractParametersFilter, buttonActionListener);
        TypeToggleButton addressButton = new TypeToggleButton("\u0430\u0434\u0440\u0435\u0441", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0430\u0434\u0440\u0435\u0441", "2", contractParametersFilter, buttonActionListener);
        TypeToggleButton emailButton = new TypeToggleButton("e-mail", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 e-mail", "3", contractParametersFilter, buttonActionListener);
        TypeToggleButton dateButton = new TypeToggleButton("\u0434\u0430\u0442\u0430", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0434\u0430\u0442\u0430", "6", contractParametersFilter, buttonActionListener);
        TypeToggleButton flagButton = new TypeToggleButton("\u0444\u043b\u0430\u0433", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0444\u043b\u0430\u0433", "5", contractParametersFilter, buttonActionListener);
        TypeToggleButton servContractButton = new TypeToggleButton("\u043e\u0431\u0441\u043b. \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "4", contractParametersFilter, buttonActionListener);
        TypeToggleButton listButton = new TypeToggleButton("\u0441\u043f\u0438\u0441\u043e\u043a", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0441\u043f\u0438\u0441\u043e\u043a", "7", contractParametersFilter, buttonActionListener);
        TypeToggleButton multiListButton = new TypeToggleButton("\u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043e\u043a", "11", contractParametersFilter, buttonActionListener);
        TypeToggleButton contractButton = new TypeToggleButton("\u0434\u043e\u0433\u043e\u0432\u043e\u0440", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0442\u0438\u043f\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440", "8", contractParametersFilter, buttonActionListener);
        this.extPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.extPanel.add((Component)textButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)addressButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)phoneButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)emailButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)flagButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)dateButton, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)listButton, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)multiListButton, new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)contractButton, new GridBagConstraints(9, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 0), 0, 0));
        this.extPanel.add((Component)servContractButton, new GridBagConstraints(10, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 5, 5), 0, 0));
        BGButton copyButton = new BGButton("\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437...");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContractParamPanel.this.initCopyPanle) {
                    ContractParamPanel.this.initCopyPanel();
                }
                ContractParamPanel.this.tableLayout.show(ContractParamPanel.this.tablePanel, "copy");
                DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
                ContractTabbedPane pane = BGClientBase.getFrame().getTabbedPane();
                for (int index = 0; index < pane.getTabCount(); ++index) {
                    String id;
                    Component comp = pane.getComponentAt(index);
                    if (comp == null || !(comp instanceof BGTabPanel)) continue;
                    BGTabPanel panel = (BGTabPanel)comp;
                    String panelId = panel.getTabId();
                    String title = panel.getTabTitle() + " [ " + panel.getAttribute("contractComment") + " ]";
                    if (!panelId.startsWith("contract_") || (id = panelId.substring(9)).equals(String.valueOf(ContractParamPanel.this.getContractId()))) continue;
                    ListItem item = new ListItem(title);
                    item.setAttribute("id", id);
                    model.addElement(item);
                }
                ContractParamPanel.this.contractPanel.getList().setModel(model);
                ContractParamPanel.this.paramList.getList().setModel(new DefaultListModel());
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        panel.add((Component)groupParamsButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)allParamsButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.filledButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)this.typesButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)copyButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430: "), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 5, 5), 0, 0));
        panel.add(this.groups, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.extPanel, new GridBagConstraints(0, 1, 7, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void initCopyPanel() {
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        JButton copyReplaceButton = new JButton(" \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c (\u0441 \u0437\u0430\u043c\u0435\u043d\u043e\u0439) ");
        copyReplaceButton.addActionListener(e -> this.copyParameters("replace"));
        JButton copyAddButton = new JButton(" \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c (\u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435) ");
        copyAddButton.addActionListener(e -> this.copyParameters("add"));
        this.contractPanel = new TitleJList("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        this.contractPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    ContractParamPanel.this.getParameterList();
                }
            }
        });
        this.patternPanel = new TitleJList("\u0428\u0430\u0431\u043b\u043e\u043d\u044b");
        this.patternPanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    ListItem listItem = (ListItem)((JList)event.getSource()).getSelectedValue();
                    ContractParamPanel.this.setSelectedParameterList(Utils.toIntegerSet((String)listItem.getAttribute("pids")));
                }
            }
        });
        ActionListener filterActionListener = e -> this.getParameterList();
        ParamRadioButton allButton = new ParamRadioButton("\u0432\u0441\u0435", "all", false, filterActionListener);
        ParamRadioButton filledButton = new ParamRadioButton("\u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b\u0435", "filled", true, filterActionListener);
        this.buttonGroupParam = new ButtonGroup();
        this.buttonGroupParam.add(allButton);
        this.buttonGroupParam.add(filledButton);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)allButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        filterPanel.add((Component)filledButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.paramList = new BGControlPanelListSelect(false);
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setBorder(new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        paramPanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.paramList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)copyReplaceButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)copyAddButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)returnButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 3, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.contractPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)paramPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.patternPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tablePanel.add((Component)panel, "copy");
        this.getContractParameterCopyPatternList();
        this.initCopyPanle = true;
    }

    protected void copyParameters(String mode) {
        ListItem item = this.contractPanel.getList().getSelectedValue();
        int contractId = Utils.parseInt((String)item.getAttribute("id"));
        HashSet<Integer> pids = new HashSet<Integer>();
        DefaultListModel model = (DefaultListModel)this.paramList.getList().getModel();
        for (int index = 0; index < model.getSize(); ++index) {
            item = (ListItem)model.get(index);
            if (!item.isSelected()) continue;
            pids.add(Utils.parseInt((String)item.getAttribute("id"), -1));
        }
        Request request = new Request();
        request.setModule("contract");
        request.setAction("CopyContractParameters");
        request.setContractId(this.getContractId());
        request.setAttribute("fromContractId", contractId);
        request.setAttribute("mode", mode);
        request.setAttribute("pids", Utils.toString(pids, ","));
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tableLayout.show(this.tablePanel, "param");
            this.setData();
        }
    }

    protected void clearContractHistory() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ClearParameterHistory");
            request.setAttribute("cid", this.getContractId());
            request.setAttribute("pid", this.selectedPid);
            request.setAttribute("pt", this.selectedPt);
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.renewHistoryTable(this.selectedPid, this.selectedPt);
            }
        }
    }

    protected void getContractParameterCopyPatternList() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetContractParameterCopyPatternList");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
            ListItem item = new ListItem("\u0411\u0435\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
            item.setAttribute("pids", "0");
            model.addElement(item);
            for (Element itemElement : XMLUtils.selectElements(doc, "//data/list/item")) {
                String value = itemElement.getAttribute("value");
                if (Utils.isBlankString(value)) {
                    value = "\u043d/\u0437";
                }
                item = new ListItem(itemElement.getAttribute("title"));
                item.setAttribute("pids", itemElement.getAttribute("pids"));
                model.addElement(item);
            }
            this.patternPanel.getList().setModel(model);
        }
    }

    protected void getParameterList() {
        ListItem listItem = this.contractPanel.getList().getSelectedValue();
        if (listItem != null) {
            int contractId = Utils.parseInt((String)listItem.getAttribute("id"));
            Request request = new Request();
            request.setModule("contract");
            request.setAction("GetContractParameterList");
            request.setAttribute("cid", contractId);
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                DefaultListModel<ListItem> model = this.paramList.getListModel();
                model.removeAllElements();
                String actionCommand = this.buttonGroupParam.getSelection().getActionCommand();
                for (Element itemElement : XMLUtils.selectElements(doc, "//data/list/item")) {
                    String value = itemElement.getAttribute("value");
                    if (Utils.isBlankString(value)) {
                        value = "\u043d/\u0437";
                    }
                    if (!actionCommand.equals("all") && value.equals("\u043d/\u0437")) continue;
                    ListItem item = new ListItem("<html>" + itemElement.getAttribute("title") + ":  <i>" + value + "</i></html>");
                    item.setAttribute("id", itemElement.getAttribute("id"));
                    model.addElement(item);
                }
                this.patternPanel.getList().setSelectedIndex(0);
            }
        }
    }

    protected void setSelectedParameterList(Set<Integer> pids) {
        ListItem patternItem = this.patternPanel.getList().getSelectedValue();
        if (patternItem != null) {
            DefaultListModel<ListItem> model = this.paramList.getListModel();
            for (int index = 0; index < model.getSize(); ++index) {
                ListItem item = model.get(index);
                item.setSelected(pids.contains(Utils.parseInt((String)item.getAttribute("id"), -1)));
            }
            this.paramList.getList().repaint();
        }
    }

    @Override
    public void setData() {
        this.customerParamPanel.performAction("refresh");
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ContractParameters");
        request.setContractId(this.getContractId());
        if ("all".equals(this.buttonGroup2.getSelection().getActionCommand())) {
            request.setAttribute("all", "1");
        }
        if (!this.isGet) {
            request.setAttribute("list", "1");
        }
        this.parametersDocument = TransferManager.getDocument(request);
        this.setDocument(this.parametersDocument);
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.fl = false;
            Element condel = XMLUtils.selectElement(doc, "//condel");
            this.isGet = true;
            Element groupsNode = XMLUtils.selectElement(doc, "//groups");
            if (groupsNode != null && groupsNode.hasChildNodes()) {
                this.groups.setModel(ClientUtils.buildComboBox(groupsNode, null));
            }
            String pgid = XMLUtils.getAttribute(condel, "pgid", "0");
            for (int i = 0; i < this.groups.getItemCount(); ++i) {
                ComboBoxItem item = this.groups.getItemAt(i);
                if (!pgid.equals(item.getObject().toString())) continue;
                this.groups.setSelectedIndex(i);
                break;
            }
            String button = null;
            if (this.typesButton.isSelected()) {
                button = this.buttonGroup1.getSelection().getActionCommand();
            }
            this.tableContractParameters.setRowsData(XMLUtils.selectNode(doc, "//parameters"), button, this.filledButton.isSelected());
            this.fl = true;
        }
    }

    private void updateParameter(String action, String pt, String pid, Object value, int row) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(action);
        request.setContractId(this.getContractId());
        request.setAttribute("id", String.valueOf(this.getContractId()));
        request.setAttribute("pid", pid);
        if (pt.equals("1") && value instanceof String) {
            request.setAttribute("value", value);
            ClientUtils.checkStatus(TransferManager.getDocument(request));
            this.setData();
        } else if (pt.equals("5") && value instanceof Boolean) {
            request.setAttribute("value", (Boolean)value != false ? "1" : "0");
            ClientUtils.checkStatus(TransferManager.getDocument(request));
            this.setData();
        }
    }

    private void groups_itemStateChanged(ItemEvent e) {
        if (this.fl && e.getStateChange() == 1) {
            ComboBoxItem item = (ComboBoxItem)this.groups.getSelectedItem();
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("SetGrContract");
            request.setAttribute("pgid", item.getObject());
            request.setContractId(this.getContractId());
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void renewHistoryTable(int pid, int pt) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetParameterHistory");
        request.setAttribute("cid", this.getContractId());
        request.setAttribute("pid", pid);
        request.setAttribute("pt", pt);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ArrayList<HistoryData> data = new ArrayList<HistoryData>();
            for (Element element : XMLUtils.selectElements(doc, "//data/table/data/row")) {
                HistoryData historyData = new HistoryData();
                historyData.when = TimeUtils.parseLocalDateTime(element.getAttribute("when"), "dd.MM.yyyy HH:mm:ss");
                historyData.value = element.getAttribute("value");
                historyData.who = element.getAttribute("who");
                data.add(historyData);
            }
            this.historyTableModel.setData(data);
            this.selectedPid = pid;
            this.selectedPt = pt;
        }
    }

    private void tableContract_enterPressed() {
        int row = this.tableContractParameters.getSelectedRow();
        if (row > -1) {
            this.openEditor(row);
        }
    }

    private void tableContract_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int row = this.tableContractParameters.getSelectedRow();
        if (e.getClickCount() == 1 && row > -1) {
            ContractParameterTableRow tr = (ContractParameterTableRow)this.tableContractParameters.getValueAt(row, 0);
            int col = this.tableContractParameters.getSelectedColumn();
            if (col == 2 && tr.getParameterType() != 10) {
                if (!this.initHistoryPanel) {
                    this.initHistoryPanel();
                }
                this.tableLayout.show(this.tablePanel, "history");
                this.renewHistoryTable(tr.getParameterId(), tr.getParameterType());
            }
        } else if (e.getClickCount() == 2 && row > -1) {
            this.openEditor(row);
        }
    }

    private void openEditor(int row) {
        ContractParameterTableRow tr = (ContractParameterTableRow)this.tableContractParameters.getValueAt(row, 0);
        String pid = String.valueOf(tr.getParameterId());
        switch (tr.getParameterType()) {
            case 1: {
                this.tableContractParameters.editCellAt(row, 1);
                break;
            }
            case 2: {
                this.addressEditor.setId(pid);
                this.editorLayout.show(this.editorPanel, "address");
                this.editorContainerSetVisible(true);
                this.addressEditor.setData();
                break;
            }
            case 3: {
                this.emailEditor.setId(pid);
                this.editorLayout.show(this.editorPanel, "email");
                this.editorContainerSetVisible(true);
                this.emailEditor.setData();
                break;
            }
            case 4: {
                this.serviceEditor.setId(pid);
                this.editorLayout.show(this.editorPanel, "service");
                this.editorContainerSetVisible(true);
                this.serviceEditor.setData();
                break;
            }
            case 5: {
                this.tableContractParameters.setValueAt((Boolean)this.tableContractParameters.getValueAt(row, 1) != false ? Boolean.FALSE : Boolean.TRUE, row, 1);
                break;
            }
            case 6: {
                String dateStr = (String)tr.getValue();
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                GregorianCalendar dt = new GregorianCalendar();
                try {
                    dt.setTime(TimeUtils.parseDate(dateStr, format));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CalendarDialog calendar = new CalendarDialog();
                calendar.setCalendar(dt);
                calendar.setModal(true);
                if (calendar.showDialog().equals("ok")) {
                    Calendar time = calendar.getCalendar();
                    dateStr = time == null ? "" : format.format(time.getTime());
                    Request request = new Request();
                    request.setModule(this.module);
                    request.setAction("UpdateParameterType6");
                    request.setAttribute("cid", this.getContractId());
                    request.setAttribute("pid", String.valueOf(tr.getParameterId()));
                    request.setAttribute("value", dateStr);
                    if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                        this.setData();
                    }
                    EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
                }
                calendar.dispose();
                break;
            }
            case 7: {
                this.listEditor.setId(pid);
                this.listEditor.setData();
                this.editorLayout.show(this.editorPanel, "list");
                this.editorContainerSetVisible(true);
                break;
            }
            case 8: {
                DialogContractSelect dialog = new DialogContractSelect(true, true, 0);
                if ("ok".equals(dialog.showDialog())) {
                    String[] sel = dialog.getSelected();
                    Request request = new Request();
                    request.setModule(this.module);
                    request.setAction("UpdateParameterType8");
                    request.setAttribute("cid", this.getContractId());
                    request.setAttribute("pid", String.valueOf(tr.getParameterId()));
                    request.setAttribute("value", sel[0]);
                    if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                        this.setData();
                    }
                    EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
                }
                dialog.dispose();
                break;
            }
            case 9: {
                this.phoneEditor.setId(pid);
                this.editorLayout.show(this.editorPanel, "phone");
                this.editorContainerSetVisible(true);
                this.phoneEditor.setData();
                break;
            }
            case 11: {
                this.multiListEditor.setId(pid);
                this.multiListEditor.setData();
                this.editorLayout.show(this.editorPanel, "multilist");
                this.editorContainerSetVisible(true);
            }
        }
    }

    private void editorContainerSetVisible(boolean visible) {
        this.bgButtonPanel.getButtonOK().setEnabled(true);
        this.editorContainer.setVisible(visible);
    }

    @Override
    @Deprecated
    public void init(String module, int mid) {
        throw new UnsupportedOperationException("Use init( JFrame frame, final String module, final int mid, final int cid )");
    }

    public void init(final String module, final int mid, final int cid) {
        super.init(module, mid);
        super.setContractId(cid);
        final Thread initThread = new Thread(){

            @Override
            public void run() {
                try {
                    10.sleep(100L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                ContractParamPanel.this.editorPanel.setLayout(ContractParamPanel.this.editorLayout);
                ContractParamPanel.this.editorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
                ContractParamPanel.this.editorContainer.setLayout(new GridBagLayout());
                ContractParamPanel.this.bgButtonPanel = new BGButtonPanelRestoreOkCancelHelp();
                ContractParamPanel.this.bgButtonPanel.addActionListener(ContractParamPanel.this.buttonActions);
                ContractParamPanel.this.editorContainer.add((Component)ContractParamPanel.this.editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                ContractParamPanel.this.editorContainer.add((Component)ContractParamPanel.this.bgButtonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
                ContractParamPanel.this.addressEditor = new AddressEditor();
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.addressEditor, "address");
                ContractParamPanel.this.emailEditor = new EmailEditor();
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.emailEditor, "email");
                ContractParamPanel.this.serviceEditor = new ServiceEditor();
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.serviceEditor, "service");
                ContractParamPanel.this.listEditor = new ListParamEditor(ContractParamPanel.this.buttonActions);
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.listEditor, "list");
                ContractParamPanel.this.phoneEditor = new PhoneEditor();
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.phoneEditor, "phone");
                ContractParamPanel.this.multiListEditor = new MultiListParamEditor();
                ContractParamPanel.this.editorPanel.add((Component)ContractParamPanel.this.multiListEditor, "multilist");
                ContractParamPanel.this.addressEditor.setContractId(cid);
                ContractParamPanel.this.emailEditor.setContractId(cid);
                ContractParamPanel.this.serviceEditor.setContractId(cid);
                ContractParamPanel.this.listEditor.setContractId(cid);
                ContractParamPanel.this.phoneEditor.setContractId(cid);
                ContractParamPanel.this.multiListEditor.setContractId(cid);
                ContractParamPanel.this.addressEditor.setOkButton(ContractParamPanel.this.bgButtonPanel.getButtonOK());
                ContractParamPanel.this.addressEditor.initAsync(module, mid);
                ContractParamPanel.this.emailEditor.initAsync(module, mid);
                ContractParamPanel.this.serviceEditor.initAsync(module, mid);
                ContractParamPanel.this.listEditor.initAsync(module, mid);
                ContractParamPanel.this.phoneEditor.initAsync(module, mid);
                ContractParamPanel.this.multiListEditor.initAsync(module, mid);
            }
        };
        initThread.setPriority(5);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                initThread.start();
            }
        });
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
    }

    class ButtonActions
    extends AbstractAction {
        ButtonActions() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String actionCommand = actionEvent.getActionCommand();
            if ("reset".equals(actionCommand)) {
                for (int i = 0; i < ContractParamPanel.this.editorPanel.getComponentCount(); ++i) {
                    Component comp = ContractParamPanel.this.editorPanel.getComponent(i);
                    if (!comp.isVisible()) continue;
                    ((BGPanel)comp).setData();
                    break;
                }
            } else if ("ok".equals(actionCommand)) {
                for (int i = 0; i < ContractParamPanel.this.editorPanel.getComponentCount(); ++i) {
                    Component comp = ContractParamPanel.this.editorPanel.getComponent(i);
                    if (!comp.isVisible()) continue;
                    if (((ParameterEditor)comp).updateData()) {
                        ContractParamPanel.this.editorContainerSetVisible(false);
                        ContractParamPanel.this.setData();
                    }
                    break;
                }
            } else if ("cancel".equals(actionCommand)) {
                ContractParamPanel.this.editorContainerSetVisible(false);
            } else if ("help".equals(actionCommand)) {
                ContractParamPanel.this.openHelp(ContractSubPanel_Parameters.class.getName());
            }
        }
    }

    class HistoryTableModel
    extends BGTableModel<HistoryData> {
        public HistoryTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 180, 180, 180, "when", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", -1, -1, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", 200, 200, 200, "who", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    private class TitleJList
    extends JPanel {
        private JList<ListItem> list = new JList();

        public TitleJList(String title) {
            this.setBorder(new BGTitleBorder(title));
            this.setLayout(new GridBagLayout());
            this.setMinimumSize(new Dimension(200, 100));
            this.setPreferredSize(new Dimension(350, 200));
            this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.list.setSelectionMode(0);
            this.list.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }

        public JList<ListItem> getList() {
            return this.list;
        }
    }

    private class TypeToggleButton
    extends JToggleButton {
        public TypeToggleButton(String text, String toolTipText, String actionCommand, String contractParametersFilter, ActionListener actionListener) {
            super(text);
            this.setToolTipText(toolTipText);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
            ContractParamPanel.this.buttonGroup1.add(this);
            this.setSelected(actionCommand.equals(contractParametersFilter));
        }
    }

    private class ParamRadioButton
    extends JRadioButton {
        public ParamRadioButton(String text, String actionCommand, boolean selected, ActionListener actionListener) {
            super(text);
            this.setSelected(selected);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
        }
    }

    public class HistoryData {
        LocalDateTime when = null;
        String value = null;
        String who = null;

        public LocalDateTime getWhen() {
            return this.when;
        }

        public String getValue() {
            return this.value;
        }

        public String getWho() {
            return this.who;
        }
    }
}

