/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.CalendarDialog;
import bitel.billing.module.contract.object.ContractObjectEditor;
import bitel.billing.module.contract.object.table.ContractObjectAddressEditor;
import bitel.billing.module.contract.object.table.ListParamEditor;
import bitel.billing.module.contract.object.table.ObjectParameterTableRow;
import bitel.billing.module.contract.object.table.ParameterEditor;
import bitel.billing.module.contract.object.table.TableObjectParameters;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectParamEditor
extends BGPanel {
    private ButtonPanelActions buttonPanelActions = new ButtonPanelActions();
    private TableObjectParameters tableObjectParameters = new TableObjectParameters();
    private ContractObjectAddressEditor addressEditor = new ContractObjectAddressEditor();
    private ListParamEditor listEditor = new ListParamEditor(this.buttonPanelActions);
    private CardLayout editorLayout = new CardLayout();
    private JPanel editorPanel = new JPanel();
    private JPanel paramEditorsPanel = new JPanel();
    private ContractObjectEditor contractObjectEditor;
    private BGTextField title_TF = new BGTextField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private String typeId;
    private BGUTable historyTable = null;
    private ObjectParamHistoryTableModel historyTableModel = new ObjectParamHistoryTableModel(ObjectParamEditor.class.getName());
    private CardLayout tableLayout = new CardLayout();
    private JPanel tablePanel = null;
    private int selectedPid = -1;
    private int selectedPt = -1;
    private Directory<UserInfo> userDirectory;

    public ObjectParamEditor() {
        this.historyTable = new BGUTable(this.historyTableModel);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tableObjectParameters.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ObjectParamEditor.this.tableObject_mouseClicked(e);
            }
        });
        this.tableObjectParameters.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "doEnterEditing");
        this.tableObjectParameters.getActionMap().put("doEnterEditing", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectParamEditor.this.tableObject_enterPressed();
            }
        });
        ((DefaultTableModel)this.tableObjectParameters.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (ObjectParamEditor.this.fl && ObjectParamEditor.this.tableObjectParameters.getRowCount() > 0) {
                    ObjectParameterTableRow row = (ObjectParameterTableRow)ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 0);
                    int pt = row.getParameterType();
                    int pid = row.getParameterId();
                    Object value = ObjectParamEditor.this.tableObjectParameters.getValueAt(e.getFirstRow(), 1);
                    if (pt == 1 || pt == 5) {
                        Request request = new Request();
                        request.setModule(ObjectParamEditor.this.module);
                        if (pt == 1) {
                            request.setAction("TextParamValueUpdate");
                        } else {
                            request.setAction("FlagParamValueUpdate");
                        }
                        request.setAttribute("object", ObjectParamEditor.this.id);
                        request.setAttribute("param", pid);
                        request.setAttribute("value", value);
                        if (ClientUtils.checkStatus(ObjectParamEditor.this.getDocument(request))) {
                            ObjectParamEditor.this.refreshPanels();
                        }
                    }
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_02.addActionListener(this.buttonPanelActions);
        this.paramEditorsPanel.setLayout(new GridBagLayout());
        this.paramEditorsPanel.setVisible(false);
        this.paramEditorsPanel.add((Component)this.editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paramEditorsPanel.add((Component)bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.addressEditor.setOkButton(bGControlPanel_02.getButtonOK());
        this.editorPanel.setLayout(this.editorLayout);
        this.editorPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editorPanel.add((Component)this.addressEditor, "address");
        this.editorPanel.add((Component)this.listEditor, "list");
        this.editorLayout.show(this.editorPanel, "address");
        JButton updateButton = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        updateButton.addActionListener(e -> this.updateObject());
        JPanel namePanel = new JPanel(new GridBagLayout());
        namePanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        namePanel.add((Component)this.title_TF, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        namePanel.add((Component)updateButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        JPanel historyPanel = new JPanel(new GridBagLayout());
        JButton deleteHistory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
        deleteHistory.addActionListener(e -> this.clearContractHistory());
        JButton returnButton = new JButton(" \u041a \u0441\u043f\u0438\u0441\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 ");
        returnButton.addActionListener(e -> this.tableLayout.show(this.tablePanel, "param"));
        historyPanel.add((Component)new JScrollPane(this.historyTable), new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)deleteHistory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 5, 0), 0, 0));
        historyPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        historyPanel.add((Component)returnButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 15), 0, 0));
        JPanel paramPanel = new JPanel(new GridBagLayout());
        paramPanel.setLayout(new GridBagLayout());
        paramPanel.add((Component)namePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        paramPanel.add((Component)new JScrollPane(this.tableObjectParameters), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        paramPanel.add((Component)this.paramEditorsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tablePanel = new JPanel(this.tableLayout);
        this.tablePanel.add((Component)paramPanel, "param");
        this.tablePanel.add((Component)historyPanel, "history");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ObjectGet");
        request.setAttribute("id", this.id);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element object = XMLUtils.selectElement(doc, "//object");
            this.period.setDateString1(object.getAttribute("date1"));
            this.period.setDateString2(object.getAttribute("date2"));
            this.title_TF.setText(object.getAttribute("title"));
            this.typeId = object.getAttribute("type_id");
        }
        this.loadObjectParams();
    }

    public void loadObjectParams() {
        this.fl = false;
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ObjectParamTable");
        request.setAttribute("object", this.id);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tableObjectParameters.setRowsData(XMLUtils.selectNode(doc, "//table"));
        }
        this.fl = true;
    }

    private void tableObject_enterPressed() {
        int row = this.tableObjectParameters.getSelectedRow();
        if (row > -1) {
            this.openEditor(row);
        }
    }

    private void tableObject_mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int row = this.tableObjectParameters.getSelectedRow();
        if (e.getClickCount() == 2 && row > -1) {
            this.openEditor(row);
        } else if (e.getClickCount() == 1 && row > -1) {
            ObjectParameterTableRow tr = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
            int col = this.tableObjectParameters.getSelectedColumn();
            if (col == 2) {
                this.tableLayout.show(this.tablePanel, "history");
                this.renewHistoryTable(tr.getParameterId(), tr.getParameterType());
            }
        }
    }

    private void openEditor(int row) {
        ObjectParameterTableRow tr = (ObjectParameterTableRow)this.tableObjectParameters.getValueAt(row, 0);
        int pt = tr.getParameterType();
        int pid = tr.getParameterId();
        if (pt != -1) {
            ListParamEditor editor = null;
            if (pt == 4) {
                this.addressEditor.setId(String.valueOf(pid));
                this.addressEditor.setObjectId(this.id);
                this.addressEditor.setData();
                this.editorLayout.show(this.editorPanel, "address");
                this.paramEditorsPanel.setVisible(true);
            } else if (pt == 3) {
                String dateStr = (String)tr.getValue();
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                GregorianCalendar dt = new GregorianCalendar();
                try {
                    dt.setTime(format.parse(dateStr));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CalendarDialog calendar = new CalendarDialog();
                calendar.setCalendar(dt);
                calendar.setModal(true);
                if (calendar.showDialog().equals("ok")) {
                    Calendar time = calendar.getCalendar();
                    Request request = new Request();
                    request.setModule(this.module);
                    request.setAction("DateParamValueUpdate");
                    request.setAttribute("object", this.id);
                    request.setAttribute("param", String.valueOf(tr.getParameterId()));
                    request.setAttribute("value", time == null ? "" : format.format(time.getTime()));
                    if (ClientUtils.checkStatus(this.getDocument(request))) {
                        this.refreshPanels();
                    }
                }
            } else if (pt == 2) {
                editor = this.listEditor;
                this.editorLayout.show(this.editorPanel, "list");
                this.paramEditorsPanel.setVisible(true);
            } else if (pt == 1) {
                this.tableObjectParameters.editCellAt(row, 1);
            } else if (pt == 5) {
                this.tableObjectParameters.setValueAt((Boolean)this.tableObjectParameters.getValueAt(row, 1) != false ? Boolean.FALSE : Boolean.TRUE, row, 1);
            }
            if (editor != null) {
                editor.setObjectId(this.id);
                editor.setId(String.valueOf(pid));
                ((BGPanel)editor).setData();
            }
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.addressEditor.init(this.module, mid);
        this.listEditor.init(this.module, mid);
    }

    public void setContractObjectEditor(ContractObjectEditor contractObjectEditor) {
        this.contractObjectEditor = contractObjectEditor;
    }

    private void updateObject() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("ObjectUpdate");
        req.setAttribute("id", this.id);
        req.setAttribute("type", this.typeId);
        req.setAttribute("title", this.title_TF.getText());
        req.setAttribute("date1", this.period.getDateString1());
        req.setAttribute("date2", this.period.getDateString2());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            this.refreshPanels();
        }
    }

    private void refreshPanels() {
        this.setData();
        this.contractObjectEditor.setData();
    }

    private void renewHistoryTable(int pid, int pt) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetParamHistory");
        request.setAttribute("object", this.id);
        request.setAttribute("param", pid);
        request.setAttribute("pt", pt);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ArrayList<Element> listData = new ArrayList<Element>();
            for (Element element : XMLUtils.selectElements(doc, "//data/table/data/row")) {
                listData.add(element);
            }
            this.historyTableModel.setData(listData);
            this.selectedPid = pid;
            this.selectedPt = pt;
        }
    }

    protected void clearContractHistory() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ClearParamHistory");
            request.setAttribute("object", this.id);
            request.setAttribute("param", this.selectedPid);
            request.setAttribute("pt", this.selectedPt);
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.renewHistoryTable(this.selectedPid, this.selectedPt);
            }
        }
    }

    class ButtonPanelActions
    extends AbstractAction {
        ButtonPanelActions() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("reset".equals(actionCommand)) {
                for (int i = 0; i < ObjectParamEditor.this.editorPanel.getComponentCount(); ++i) {
                    Component comp = ObjectParamEditor.this.editorPanel.getComponent(i);
                    if (!comp.isVisible()) continue;
                    ((BGPanel)comp).setData();
                    break;
                }
            } else if ("ok".equals(actionCommand)) {
                for (int i = 0; i < ObjectParamEditor.this.editorPanel.getComponentCount(); ++i) {
                    Component comp = ObjectParamEditor.this.editorPanel.getComponent(i);
                    if (!comp.isVisible()) continue;
                    boolean update = false;
                    if (comp instanceof ParameterEditor) {
                        update = ((ParameterEditor)comp).updateData();
                    } else if (comp instanceof bitel.billing.module.contract.ParameterEditor) {
                        update = ((bitel.billing.module.contract.ParameterEditor)comp).updateData();
                    }
                    if (update) {
                        ObjectParamEditor.this.paramEditorsPanel.setVisible(false);
                        ObjectParamEditor.this.refreshPanels();
                    }
                    break;
                }
            } else if ("cancel".equals(actionCommand)) {
                ObjectParamEditor.this.paramEditorsPanel.setVisible(false);
            }
        }
    }

    class ObjectParamHistoryTableModel
    extends BGTableModel<Element> {
        public ObjectParamHistoryTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 100, 150, 200, "when", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 10, 500, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u0442\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u043b", 100, 150, 200, "who", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
        }

        @Override
        public Object getValue(Element val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("who".equals(identifier)) {
                UserInfo user = ObjectParamEditor.this.userDirectory.get(Utils.parseInt(val.getAttribute("who"), -2));
                return user != null ? user.getName() : val.getAttribute("who");
            }
            return super.getValue(val, column);
        }
    }
}

