/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.ListItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.contract.directory.ListParamsEditor;
import bitel.billing.module.contract.directory.ListValuesPopupEditor;
import bitel.billing.module.contract.directory.MultiListValuesPopupEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

class NewValuesPanel
extends BGPanel {
    private DefaultListModel<ListItem> paramsModel = new DefaultListModel();
    private JList<ListItem> paramsList = new JList<ListItem>(this.paramsModel);
    private BGTable listCustomTable = new BGTable();
    private ListValuesPopupEditor listParamPopupEditor;
    private String paramId = null;
    protected boolean mode = false;

    public NewValuesPanel(Document moduleDoc, boolean mode) {
        this.moduleDoc = moduleDoc;
        this.mode = mode;
        this.listParamPopupEditor = mode ? new MultiListValuesPopupEditor() : new ListValuesPopupEditor();
        this.listParamPopupEditor.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("UpdateListValue")) {
                this.showlistCustomValue();
            }
        });
        this.jbInit();
        this.listCustomTable.setHeader(ListParamsEditor.class.getPackage().getName() + ".setup", moduleDoc, "listCustomValue");
        this.listCustomTable.setSelectionMode(0);
        this.paramsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListItem listItem = NewValuesPanel.this.paramsList.getSelectedValue();
                    NewValuesPanel.this.paramId = (String)listItem.getAttribute("id");
                    NewValuesPanel.this.showlistCustomValue();
                }
            }
        });
        this.listCustomTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListItem listItem = NewValuesPanel.this.paramsList.getSelectedValue();
                    int row = NewValuesPanel.this.listCustomTable.getSelectedRow();
                    String customValue = String.valueOf(NewValuesPanel.this.listCustomTable.getColumnValue(row, "custom_value"));
                    if (listItem != null) {
                        NewValuesPanel.this.listParamPopupEditor.show(NewValuesPanel.this.listCustomTable, e.getX(), NewValuesPanel.this.listCustomTable.getHeight());
                        NewValuesPanel.this.listParamPopupEditor.setText(customValue);
                        NewValuesPanel.this.listParamPopupEditor.init(NewValuesPanel.this.module, NewValuesPanel.this.paramId);
                        NewValuesPanel.this.listParamPopupEditor.setCustomValue(customValue);
                        NewValuesPanel.this.listParamPopupEditor.setData();
                    }
                }
            }
        });
        this.listParamPopupEditor.setVisible(false);
    }

    private void jbInit() {
        JPanel listParams = new JPanel(new GridBagLayout());
        listParams.setBorder(this.mode ? new BGTitleBorder("\u041c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043a\u0438") : new BGTitleBorder("C\u043f\u0438\u0441\u043a\u0438"));
        listParams.add((Component)new JScrollPane(this.paramsList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel listCustomTablePanel = new JPanel(new GridBagLayout());
        listCustomTablePanel.setBorder(this.mode ? new BGTitleBorder("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043b\u044c\u0442\u0438\u0441\u043f\u0438\u0441\u043a\u0430") : new BGTitleBorder("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430"));
        listCustomTablePanel.add((Component)new JScrollPane(this.listCustomTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel listCustomPanel = new JPanel(new GridBagLayout());
        listCustomPanel.add((Component)listCustomTablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, listParams, (Component)listCustomPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData(Node node) {
        ClientUtils.buildList(this.paramsList, this.paramsModel, node);
        this.showlistCustomValue();
    }

    public void showlistCustomValue() {
        if (this.paramId != null) {
            Request request = new Request();
            request.setAction(this.mode ? "GetCustomMultiListValue" : "GetCustomListValue");
            request.setModule(this.module);
            request.setAttribute("pid", this.paramId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element tableNode = XMLUtils.selectElement(doc, "//table");
                this.listCustomTable.updateData(tableNode);
            }
        }
    }

    public boolean getMode() {
        return this.mode;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }
}

