/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import javax.jms.JMSException;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.common.worker.WorkerTask;

public abstract class BatchWorker<E, C extends ServerContext>
extends WorkerTask<C> {
    private static final Logger logger = LogManager.getLogger();
    protected long batchWait = 5000L;
    protected long errorPause = 60000L;
    protected final long waitTimeout;
    protected final boolean waitEndlessly;
    protected volatile boolean working = true;
    private E firstTask;

    public BatchWorker() {
        this(1000L);
    }

    public BatchWorker(long waitTimeout) {
        if (waitTimeout > 0L) {
            this.waitTimeout = waitTimeout;
            this.waitEndlessly = false;
        } else {
            this.waitTimeout = 100L;
            this.waitEndlessly = true;
        }
    }

    @Override
    protected synchronized void runImpl() throws Exception {
        while (this.working) {
            int result = this.internalRunWorker(this.waitTimeout, this.waitEndlessly);
            if (result >= 0) continue;
            try {
                logger.info("Execution error - waiting " + this.errorPause + "ms for next try.");
                Thread.sleep(this.errorPause);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
                logger.error((Object)ex);
            }
        }
        this.internalRunWorker(1000L, false);
    }

    protected abstract E takeImpl() throws Exception;

    protected int internalRunWorker(long timeout, boolean wait) {
        int result = 0;
        try {
            this.firstTask = this.poll(timeout);
            if (wait) {
                if (this.firstTask == null) {
                    this.firstTask = this.takeImpl();
                }
                result = this.runWorker() ? 1 : -1;
            } else if (this.firstTask != null) {
                result = this.runWorker() ? 1 : -1;
            }
        }
        catch (Throwable e) {
            result = -1;
            logger.error(this.getClass() + ": " + e.getMessage(), e);
        }
        return result;
    }

    protected abstract E pollImpl(long var1) throws Exception;

    protected E poll(long timeout) throws BGException {
        E firstTask = this.firstTask;
        if (firstTask != null) {
            this.firstTask = null;
            return firstTask;
        }
        try {
            return this.pollImpl(timeout);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public boolean doTasks() throws BGException {
        try {
            E task;
            while ((task = this.poll(this.batchWait)) != null) {
                if (this.internalDoTask(task)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    protected boolean internalDoTask(E task) throws JMSException, JAXBException, BGException {
        try {
            this.doTask(task);
            ((ServerContext)this.context).commit();
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    protected abstract boolean runWorker() throws BGException;

    public abstract Object doTask(E var1) throws BGException;

    public void shutdown() throws BGException {
        this.working = false;
    }
}

