/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.util.StringCache;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceInterfaceIndexDao;

public class DevicePortDao
extends AbstractDao<DeviceInterface> {
    private DeviceInterfaceIndexDao interfaceIndexDao;
    private static final StringCache TITLE_CACHE = new StringCache(512);
    private PreparedStatement deletePS;
    private PreparedStatement insertPS;

    public DevicePortDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_device_port");
        this.interfaceIndexDao = new DeviceInterfaceIndexDao(con, moduleId);
    }

    protected DeviceInterface getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, true, true);
    }

    protected DeviceInterface getFromRS(ResultSet rs, boolean title, boolean indexList) throws SQLException, BGException {
        DeviceInterface result = new DeviceInterface();
        result.setDeviceId(rs.getInt("deviceId"));
        result.setPort(rs.getInt("port"));
        result.setStatus(rs.getInt("status"));
        result.setIpCategoryId(rs.getInt("ipCategoryId"));
        if (title) {
            result.setTitle(TITLE_CACHE.intern(rs.getString("title")));
            result.setComment(rs.getString("comment"));
        }
        if (indexList) {
            result.setIndexList(this.interfaceIndexDao.list(result.getDeviceId(), result.getPort(), null));
        }
        return result;
    }

    protected void updateImpl(DeviceInterface b) throws BGException, SQLException {
        try {
            if (Utils.isBlankString((String)b.getTitle())) {
                b.setTitle(String.valueOf(b.getPort()));
            }
            PreparedStatement ps = this.deletePS == null ? (this.deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE deviceId=? AND port=?")) : this.deletePS;
            ps.setInt(1, b.getDeviceId());
            ps.setInt(2, b.getPort());
            ps.executeUpdate();
            ps = this.insertPS == null ? (this.insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (deviceId, port, title, status, ipCategoryId, comment) VALUES (?,?,?,?,?,?)", 1)) : this.insertPS;
            ps.setInt(1, b.getDeviceId());
            ps.setInt(2, b.getPort());
            ps.setString(3, b.getTitle());
            ps.setInt(4, b.getStatus());
            ps.setInt(5, b.getIpCategoryId());
            ps.setString(6, Utils.maskNull((String)b.getComment()));
            ps.executeUpdate();
            this.interfaceIndexDao.update(b.getDeviceId(), b.getPort(), b.getIndexList());
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<DeviceInterface> list(int deviceId, int status, boolean title, boolean indexList, String interfaceTitle) throws BGException {
        try {
            ArrayList<DeviceInterface> result = new ArrayList<DeviceInterface>();
            PreparedStatement ps = this.listImplPS(title ? "*" : "deviceId, port, status, ipCategoryId", "deviceId=? AND (? OR status=?) AND (? OR title like ?)", "port", 0, 0);
            int index = 1;
            ps.setInt(index++, deviceId);
            ps.setBoolean(index++, status < 0);
            ps.setInt(index++, status);
            ps.setBoolean(index++, interfaceTitle == null);
            ps.setString(index++, "%" + interfaceTitle + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, title, indexList));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<DeviceInterface> list(int deviceId, int status, boolean title, boolean indexList, boolean subscription) throws BGException {
        if (!subscription) {
            return this.list(deviceId, status, title, indexList, null);
        }
        try {
            ArrayList<DeviceInterface> result = new ArrayList<DeviceInterface>();
            PreparedStatement ps = this.listImplPS(title ? this.tableName + ".*, s.subscriberId, s.subscriberTitle, c.status as contractStatus" : this.tableName + ".deviceId, " + this.tableName + ".port, " + this.tableName + ".status, " + this.tableName + ".ipCategoryId, s.subscriberId, s.subscriberTitle", "LEFT JOIN inv_device_port_subscription_" + this.moduleId + " as s ON s.deviceId=" + this.tableName + ".deviceId AND s.port=" + this.tableName + ".port AND (s.dateFrom IS NULL OR s.dateFrom<=?) AND (s.dateTo IS NULL OR s.dateTo>=?)LEFT JOIN  inet_serv_" + this.moduleId + " as ise ON ise.id = s.subscriberId LEFT JOIN contract as c ON c.id = ise.contractId", this.tableName + ".deviceId=? AND (? OR " + this.tableName + ".status=?)", "port", 0, 0);
            java.sql.Date now = TimeUtils.convertDateToSqlDate((Date)new Date());
            ps.setDate(1, now);
            ps.setDate(2, now);
            ps.setInt(3, deviceId);
            ps.setBoolean(4, status < 0);
            ps.setInt(5, status);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DeviceInterface iface = this.getFromRS(rs, title, indexList);
                int contractStatus = rs.getInt("contractStatus");
                Object statusTitle = "";
                String subscriberTitle = null;
                if (!rs.wasNull()) {
                    statusTitle = " (" + StatusCache.getInstance().getStatusTitle(contractStatus) + ")";
                }
                iface.setSubscriberId(rs.getInt("subscriberId"));
                subscriberTitle = rs.getString("subscriberTitle");
                if (subscriberTitle != null) {
                    iface.setSubscriberTitle(rs.getString("subscriberTitle") + (String)statusTitle);
                }
                result.add(iface);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void delete(int deviceId, int port) throws BGException {
        this.delete("deviceId=? AND port=?", new Object[]{deviceId, port});
    }

    public DeviceInterface get(int deviceId, int port) throws BGException {
        return (DeviceInterface)this.get("deviceId=? AND port=?", new Object[]{deviceId, port});
    }
}

