/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.event.ProductSpecModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ServiceLinkModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecServiceLinkDao;

public class ProductSpecMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private volatile Map<Integer, ProductSpecItem> productSpecMap;
    private volatile Map<String, ProductSpecItem> productSpecIdentifierMap;
    private final AtomicLong version = new AtomicLong();

    public static ProductSpecMap getInstance() throws BGException {
        return InstanceHolder.instance;
    }

    ProductSpecMap() {
        try {
            final CompletableFuture future = new CompletableFuture();
            new Thread("product-spec-map-init"){

                @Override
                public void run() {
                    try {
                        EventProcessor.getInstance().addListener(ProductSpecMap.this, ProductSpecModifiedEvent.class);
                        EventProcessor.getInstance().addListener(ProductSpecMap.this, ServiceLinkModifiedEvent.class);
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    future.complete(true);
                }
            }.start();
            try {
                future.get(1L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.load();
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public long getVersion() {
        return this.version.get();
    }

    private void descendantIds(Map<Integer, ProductSpecItem> productSpecMap, int parentId, int id) {
        if (parentId > 0) {
            ProductSpecItem parentProductSpecItem = productSpecMap.get(parentId);
            parentProductSpecItem.descendantIds.add(id);
            this.descendantIds(productSpecMap, parentProductSpecItem.productSpec.getParentId(), id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() throws BGException {
        logger.info("(Re)loading ProductSpecMap");
        ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);
        try {
            ProductSpecDao productSpecDao = new ProductSpecDao(connectionSet.getConnection());
            ProductSpecServiceLinkDao serviceLinkDao = new ProductSpecServiceLinkDao(connectionSet.getConnection(), 0);
            HashMap<Integer, ProductSpecItem> productSpecMap = new HashMap<Integer, ProductSpecItem>();
            HashMap<String, ProductSpecItem> productSpecIdentifierMap = new HashMap<String, ProductSpecItem>();
            for (ProductSpec productSpec : productSpecDao.list()) {
                List<ProductSpecServiceLink> serviceLinkList = serviceLinkDao.list(productSpec.getId(), null);
                ProductSpecItem productSpecItem = new ProductSpecItem(productSpec, serviceLinkList);
                productSpecMap.put(productSpec.getId(), productSpecItem);
                productSpecIdentifierMap.put(productSpec.getIdentifier(), productSpecItem);
            }
            for (ProductSpecItem productSpecItem : productSpecMap.values()) {
                this.descendantIds(productSpecMap, productSpecItem.productSpec.getParentId(), productSpecItem.productSpec.getId());
            }
            this.version.incrementAndGet();
            this.productSpecMap = productSpecMap;
            this.productSpecIdentifierMap = productSpecIdentifierMap;
        }
        finally {
            connectionSet.recycle();
        }
    }

    public ProductSpecItem get(int productSpecId) throws BGException {
        return this.productSpecMap.get(productSpecId);
    }

    public ProductSpecItem getByIdentifier(String identifier) throws BGException {
        return this.productSpecIdentifierMap.get(identifier);
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.load();
    }

    static class InstanceHolder {
        static final ProductSpecMap instance = new ProductSpecMap();

        InstanceHolder() {
        }
    }

    public class ProductSpecItem {
        public final ProductSpec productSpec;
        public final Map<Integer, ProductSpecActivationMode> activationModeMap;
        public final List<ProductSpecServiceLink> serviceLinkList;
        final Set<Integer> descendantIds = new HashSet<Integer>();

        ProductSpecItem(ProductSpec productSpec, List<ProductSpecServiceLink> serviceLinkList) {
            this.productSpec = productSpec;
            List activationModeList = productSpec.getActivationModeList();
            this.activationModeMap = activationModeList != null ? Id.newMap((List)activationModeList) : Collections.emptyMap();
            this.serviceLinkList = serviceLinkList;
        }

        public boolean isDescendant(int productSpecId) {
            return this.descendantIds.contains(productSpecId);
        }
    }
}

