/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server.bean;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class DynamicCodeDao {
    public static final String SOURCE_ENCODING = "UTF-8";
    public static final Pattern RESOURCE_EXT_REGEXP_BLACKLIST = Pattern.compile("^bak$|^.+\\.bak$|^bak\\.\\d+$|^.+\\.bak\\.\\d+$|^exe$|^$");
    private Connection con;

    public static final String getScriptsDir() {
        Setup setup = Setup.getSetup();
        return setup.get("dynamic.src.dir", setup.get("dyn.src.dir", "dyn"));
    }

    public DynamicCodeDao(Connection con) {
        this.con = con;
    }

    public byte[] getClassData(String className) throws BGException {
        byte[] classData = null;
        try {
            String query = "SELECT data FROM script_classes WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, className);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                classData = rs.getBytes(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return classData;
    }

    public static String getClassSource(String className) throws BGException {
        StringBuilder result = new StringBuilder();
        DynamicCodeDao.readFile(result, DynamicCodeDao.getClassFile(className));
        return result.toString();
    }

    private static void readFile(StringBuilder result, File src) throws BGException {
        try (Scanner scanner = new Scanner((InputStream)new FileInputStream(src), SOURCE_ENCODING);){
            while (scanner.hasNextLine()) {
                result.append(scanner.nextLine() + "\n");
            }
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public synchronized void updateClassData(String className, byte[] data, long lastModified) throws BGException {
        try {
            String query = "UPDATE script_classes SET data=?, last_mod=? WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBlob(1, new ByteArrayInputStream(data));
            ps.setLong(2, lastModified);
            ps.setString(3, className);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO script_classes(data,last_mod,name) VALUES(?,?,?)";
                ps = this.con.prepareStatement(query);
                ps.setBlob(1, new ByteArrayInputStream(data));
                ps.setLong(2, lastModified);
                ps.setString(3, className);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public static void updateClassSource(String className, DataHandler data) throws BGException {
        File src = DynamicCodeDao.getClassFile(className);
        try {
            if (src.exists()) {
                DynamicCodeDao.backup(className);
            } else {
                src.getParentFile().mkdirs();
                src.createNewFile();
            }
            data.writeTo((OutputStream)new FileOutputStream(src));
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static void backup(String className) throws IOException, BGException {
        File bak = DynamicCodeDao.getClassBakFile(className);
        bak.createNewFile();
        DynamicCodeDao.writeDataToFile(bak, DynamicCodeDao.getClassSource(className));
    }

    public static void restoreSourcesFromBackup(String className) throws BGException {
        File bak = DynamicCodeDao.getClassBakFile(className);
        if (bak.exists()) {
            File src = DynamicCodeDao.getClassFile(className);
            try {
                StringBuilder sb = new StringBuilder();
                DynamicCodeDao.readFile(sb, bak);
                DynamicCodeDao.writeDataToFile(src, sb.toString());
                bak.delete();
            }
            catch (IOException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static void deleteSourcesBackup(String className) {
        File bak = DynamicCodeDao.getClassBakFile(className);
        if (bak.exists()) {
            bak.delete();
        }
    }

    public List<DynamicClass> getDynamicClasses() throws BGException {
        ArrayList<DynamicClass> result = new ArrayList<DynamicClass>();
        File scripts = new File(DynamicCodeDao.getScriptsDir());
        this.traverse(result, scripts, "");
        for (DynamicClass clazz : result) {
            this.markIfUpdated(clazz);
        }
        return result;
    }

    private void markIfUpdated(DynamicClass clazz) throws BGException {
        if (!clazz.isJavaSource()) {
            clazz.setNeedsRecompile(false);
            return;
        }
        try {
            String query = "SELECT last_mod FROM script_classes WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, clazz.getClassName());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                clazz.setNeedsRecompile(rs.getLong(1) != clazz.getLastModified());
            } else {
                clazz.setNeedsRecompile(true);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void traverse(List<DynamicClass> classes, File directory, String prefix) {
        for (File file : directory.listFiles()) {
            String extension;
            if (file.isDirectory() && !file.getName().startsWith(".")) {
                this.traverse(classes, file, prefix + file.getName() + ".");
                continue;
            }
            if (file.getName().endsWith(".java")) {
                classes.add(new DynamicClass(prefix + file.getName().substring(0, file.getName().length() - 5), file.lastModified()));
                continue;
            }
            int i = file.getName().indexOf(46);
            String string = extension = i > 0 ? file.getName().substring(i + 1) : "";
            if (RESOURCE_EXT_REGEXP_BLACKLIST.matcher(extension.toLowerCase()).matches()) continue;
            classes.add(new DynamicClass(prefix + file.getName().substring(0, file.getName().length() - extension.length() - 1), file.lastModified(), extension));
        }
    }

    public static File getClassFile(String className) {
        String extension = DynamicClass.getResourceExt(className);
        int innerClassDelim = (className = DynamicClass.getResourceName(className)).indexOf(36);
        String path = innerClassDelim >= 0 ? className.substring(0, innerClassDelim) : className;
        path = path.replace('.', File.separatorChar);
        return new File(DynamicCodeDao.getScriptsDir(), path + "." + extension);
    }

    private static File getClassBakFile(String className) {
        String path = className.replace('.', File.separatorChar);
        return new File(DynamicCodeDao.getScriptsDir(), path + ".bak");
    }

    private static void writeDataToFile(File file, String data) throws IOException {
        file.createNewFile();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), SOURCE_ENCODING);
        writer.write(data);
        writer.flush();
        writer.close();
    }

    public void updateClassInterfaces(Class<?> clazz) throws BGException {
        HashSet interfaces = new HashSet();
        this.traverseClasses(interfaces, clazz);
        try {
            String query = "DELETE FROM script_classes_ifaces WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, clazz.getName());
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO script_classes_ifaces(name,iface) VALUES(?,?)";
            ps = this.con.prepareStatement(query);
            for (Class clazz2 : interfaces) {
                ps.setString(1, clazz.getName());
                ps.setString(2, clazz2.getName());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void traverseClasses(Set<Class<?>> interfaces, Class<?> clazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            interfaces.add(iface);
        }
        if (clazz.getSuperclass() != null) {
            this.traverseClasses(interfaces, clazz.getSuperclass());
        }
    }

    public List<String> getActualClassesByInterface(String interfaceName) throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String query = "SELECT name FROM script_classes_ifaces WHERE iface=? AND name NOT LIKE '%$%'";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, interfaceName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public static void backupAndDelete(String className) throws BGException {
        try {
            DynamicCodeDao.backup(className);
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
        File srcFile = DynamicCodeDao.getClassFile(className);
        if (!srcFile.delete()) {
            throw new BGException("Cannot delete " + srcFile.getAbsolutePath());
        }
    }

    public void deleteClassFromDb(String className) throws BGException {
        try {
            String query = "DELETE FROM script_classes_ifaces WHERE name=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, className);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes WHERE name=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes_ifaces WHERE name LIKE ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className + "$%");
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes WHERE name LIKE ?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, className + "$%");
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void clearTables() throws BGException {
        try {
            String query = "DELETE FROM script_classes_ifaces";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM script_classes";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Pair<String, byte[]>> getClassData() throws BGException {
        ArrayList<Pair<String, byte[]>> result = new ArrayList<Pair<String, byte[]>>();
        try {
            String query = "SELECT name, data FROM script_classes";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                byte[] classData = rs.getBytes(2);
                if (!Utils.notBlankString((String)name) || classData == null) continue;
                result.add((Pair<String, byte[]>)new Pair((Object)name, (Object)classData));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

