/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

@WebAction(title="\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438")
public class ActionTariffOption
extends AbstractAction {
    private String moduleName = "contract";
    @Resource
    private TariffOptionService tariffOptionService;

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u0422\u0435\u043a\u0443\u0449\u0438\u0435")
    public void list() throws BGException {
        int optionId = this.req.getInt("option_id", -1);
        int modeId = this.req.getInt("mode_id", -1);
        this.context.getRequest().setAttribute("option_id", (Object)optionId);
        this.context.getRequest().setAttribute("mode_id", (Object)modeId);
        Date now = new Date();
        try (ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(this.con);){
            List<ContractTariffOption> currentContractOptionList = contractTariffOptionDao.list(this.contractId, now);
            List<TariffOption> availableOptions = this.availableOptions(now, currentContractOptionList);
            if (availableOptions.size() == 0) {
                optionId = 0;
                modeId = 0;
            } else if (optionId <= 0) {
                optionId = availableOptions.get(0).getId();
            }
            if (optionId > 0) {
                for (TariffOption option : availableOptions) {
                    if (option.getId() != optionId) continue;
                    this.context.getRequest().setAttribute("available_modes", option.getActivateModeList());
                }
            }
            this.context.getRequest().setAttribute("availableTariffOptions", availableOptions);
            HashMap<Integer, ContractTariffOption> futureList = new HashMap<Integer, ContractTariffOption>();
            for (ContractTariffOption option : currentContractOptionList) {
                if (!now.before(option.getTimeFrom())) continue;
                futureList.put(option.getId(), option);
            }
            this.context.getRequest().setAttribute("currentTariffOptions", currentContractOptionList);
            this.context.getRequest().setAttribute("futureOptions", futureList);
        }
        this.requestDispatcher(this.moduleName, "tariff_option_list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebOperation(title="\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f")
    public void activate() throws BGException {
        int tariffOptionId = this.req.getInt("tariffOptionId", -1);
        int tariffOptionModeId = this.req.getInt("tariffOptionModeId", -1);
        ActionMessage message = new ActionMessage("tariffOptionRoot", "list", "tariffOptionQuery", "\u041e\u043f\u0446\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
        if (tariffOptionId <= 0 || tariffOptionModeId <= 0) {
            message.setText("\u0422\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u043e\u043f\u0446\u0438\u044f \u0438\u043b\u0438 \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            message.setOperation("available");
        } else {
            if (BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus") != null) {
                if (this.isPayOnlyBonus(tariffOptionModeId, tariffOptionId)) {
                    if (this.req.get("redirect") != null) {
                        throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u0443\u044e \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u0431\u044b\u043b\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438.");
                    }
                    TariffOptionActivateMode mode = this.tariffOptionService.tariffOptionActivateModeGet(tariffOptionId, tariffOptionModeId);
                    BigDecimal sum = this.bonusSummaMax(mode.getChargeSumma());
                    if (this.isPayBonus(tariffOptionModeId, tariffOptionId) && sum.compareTo(mode.getChargeSumma()) >= 0) {
                        this.redirectToBonus(tariffOptionModeId, tariffOptionId);
                        return;
                    }
                    throw new BGMessageException("\u0414\u0430\u043d\u043d\u0443\u044e \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438, \u043d\u043e \u0443 \u0432\u0430\u0441 \u0438\u0445 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e. \u0423 \u0432\u0430\u0441 - " + Utils.formatCost((BigDecimal)sum) + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e - " + Utils.formatCost((BigDecimal)mode.getChargeSumma()) + ".");
                }
                if (this.isPayBonus(tariffOptionModeId, tariffOptionId) && this.req.get("redirect") == null) {
                    this.redirectToBonus(tariffOptionModeId, tariffOptionId);
                    return;
                }
            }
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.context.getConnectionSet(), (Integer)this.contractId);
            contractRuntime.lock();
            try {
                this.tariffOptionService.contractTariffOptionActivate(this.contractId, tariffOptionId, tariffOptionModeId, true);
                this.context.commit();
                message.setTabClick("tariffOptionTab1");
            }
            catch (Exception ex) {
                message.setText("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 <br>[" + ex.getLocalizedMessage() + "]");
                message.setOperation("available");
            }
            finally {
                contractRuntime.unlock();
            }
        }
        this.context.getRequest().setAttribute("message", (Object)message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438")
    public void available() throws BGException {
        Date today = new Date();
        try (ContractTariffOptionDao contractTariffOptionDao = new ContractTariffOptionDao(this.con);){
            List<ContractTariffOption> currentContractOptionList = contractTariffOptionDao.list(this.contractId, today);
            this.context.getRequest().setAttribute("availableList", this.availableOptions(today, currentContractOptionList));
        }
        this.requestDispatcher(this.moduleName, "tariff_option_available");
    }

    private List<TariffOption> availableOptions(Date today, List<ContractTariffOption> currentContractOptionList) throws BGException {
        boolean dontCheckOnActivateAlreadyActivated = this.setup.getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", this.setup.getBoolean("allow.parallel.option.activate", false));
        List<TariffOption> options = this.tariffOptionService.tariffOptionListAvailable(this.contractId, today, dontCheckOnActivateAlreadyActivated ? new ArrayList<ContractTariffOption>() : currentContractOptionList, false, true);
        ArrayList<TariffOption> availableOptions = new ArrayList<TariffOption>();
        for (TariffOption option : options) {
            if (!option.isEnable()) continue;
            availableOptions.add(option);
        }
        HashMap tariffOptionMap = new HashMap();
        HashMap<Integer, TariffOptionActivateMode> optionActivateModeMap = new HashMap<Integer, TariffOptionActivateMode>();
        options.forEach(o -> tariffOptionMap.put(o.getId(), o));
        block1: for (ContractTariffOption contractTariffOption : currentContractOptionList) {
            for (TariffOptionActivateMode tariffOptionActivateMode : ((TariffOption)((Object)tariffOptionMap.get(contractTariffOption.getOptionId()))).getActivateModeList()) {
                if (tariffOptionActivateMode.getId() != contractTariffOption.getActivatedMode()) continue;
                optionActivateModeMap.put(contractTariffOption.getId(), tariffOptionActivateMode);
                continue block1;
            }
        }
        this.context.getRequest().setAttribute("optionActivateModeMap", optionActivateModeMap);
        return availableOptions;
    }

    @WebOperation(title="\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f")
    public void deactivate() throws BGException {
        ActionMessage message = new ActionMessage("tariffOptionRoot", "list", "tariffOptionQuery", "\u041e\u043f\u0446\u0438\u044f \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
        try {
            this.tariffOptionService.contractTariffOptionDeactivate(this.contractId, this.req.getInt("tariffOptionId", -1));
        }
        catch (Exception ex) {
            message.setText("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430<br>[" + ex.getLocalizedMessage() + "]");
        }
        this.context.getRequest().setAttribute("message", (Object)message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u041e\u0442\u043c\u0435\u043d\u0430")
    public void delete() throws BGException {
        ActionMessage message = new ActionMessage("tariffOptionRoot", "list", "tariffOptionQuery", "\u041e\u043f\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430");
        try {
            this.tariffOptionService.contractTariffOptionDelete(this.contractId, this.req.getInt("tariffOptionId", -1), true);
        }
        catch (Exception ex) {
            message.setText("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430<br>[" + ex.getLocalizedMessage() + "]");
        }
        this.context.getRequest().setAttribute("message", (Object)message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f")
    public void reactivate() throws BGException {
        ActionMessage message = new ActionMessage("tariffOptionRoot", "list", "tariffOptionQuery", "\u041e\u043f\u0446\u0438\u044f \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
        try {
            this.tariffOptionService.contractTariffOptionReactivate(this.contractId, this.req.getInt("tariffOptionId", -1));
        }
        catch (Exception ex) {
            message.setText("\u041e\u043f\u0446\u0438\u044f \u043d\u0435 \u0440\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430<br>[" + ex.getLocalizedMessage() + "]");
        }
        this.context.getRequest().setAttribute("message", (Object)message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f")
    public void history() throws BGException {
        Date date = this.req.getDateTime("date", new Date());
        this.context.getRequest().setAttribute("tariffOptions", this.tariffOptionService.contractTariffOptionHistory(this.contractId, date, true));
        this.requestDispatcher(this.moduleName, "tariff_option_history");
    }

    private boolean isPayBonus(int modeId, int optionId) throws BGException {
        List<TariffOptionActivateMode> listMode = this.tariffOptionService.tariffOptionActivateModeList(optionId, new Date());
        Map<String, Object> result = EventProcessor.getInstance().doCrossComponentQuery("ru.bitel.bgbilling.plugins.bonus", 0, "isPayBonus", this.contractId, listMode, modeId, optionId);
        return Boolean.valueOf(String.valueOf(result.getOrDefault("ru.bitel.bgbilling.plugins.bonus", "false")));
    }

    private BigDecimal bonusSummaMax(BigDecimal modeChargeSumma) throws BGException {
        Map<String, Object> result = EventProcessor.getInstance().doCrossComponentQuery("ru.bitel.bgbilling.plugins.bonus", 0, "bonusSummaMax", this.contractId, 0, modeChargeSumma, false);
        return new BigDecimal(String.valueOf(result.getOrDefault("ru.bitel.bgbilling.plugins.bonus", "0")));
    }

    private boolean isPayOnlyBonus(int modeId, int optionId) throws BGException {
        Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus").getSetup();
        List list = Utils.toList((String)setup.get("tariffOptionsPaymentOnlyWithBonuses"));
        for (String str : list) {
            if (Utils.parseInt((String)str, (int)-1) != optionId) continue;
            return true;
        }
        return false;
    }

    private void redirectToBonus(int modeId, int optionId) {
        try {
            Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus").getSetup();
            String uri = setup.get("redirectUrl");
            if (uri == null) {
                uri = this.context.getRequest().getRequestURI();
            }
            String url = "/webexecuter?action=Bonus&module=ru.bitel.bgbilling.plugins.bonus&mid=0&operation=payTariffOption&optionId=" + optionId + "&modeId=" + modeId;
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.forward);
            this.context.getRequest().setAttribute("forward", (Object)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

