/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;

@WebFilter(filterName="MultipartFilter", urlPatterns={"/webexecuter"})
public class MultipartFilter
implements Filter {
    private ServletContext servletContext = null;
    protected static final Logger logger = LogManager.getLogger();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        if (logger.isDebugEnabled()) {
            logger.debug("init filter " + filterConfig.getFilterName());
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String type = request.getHeader("Content-Type");
        if (type != null && type.startsWith("multipart/form-data")) {
            File tempdir = (File)this.servletContext.getAttribute("javax.servlet.context.tempdir");
            servletRequest = new MultipartWrapper(request, tempdir.getAbsolutePath());
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        this.servletContext = null;
    }
}

