/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.find.SearchContract;
import bitel.billing.server.contract.bean.find.SearchContractModule;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SearchContractByLogin
extends SearchContractModule {
    @Override
    public String getName() {
        return "login";
    }

    @Override
    public List<Contract> findContracts(Connection con, SearchContract search, String param, Date date) {
        String sqlDate = TimeUtils.formatSQLDate((Date)date);
        StringBuilder query = new StringBuilder(200);
        boolean isLogin = Utils.parseLong((String)param) > 0L;
        this.addContractSelectPart(query);
        query.append(" INNER JOIN user_login_");
        query.append(search.getMid());
        query.append(" AS login ON contract.id=login.cid ");
        if (!isLogin) {
            query.append(" INNER JOIN user_alias_");
            query.append(search.getMid());
            query.append(" AS alias ON login.id=alias.login_id ");
        }
        query.append(" WHERE ");
        this.addContractFilter(query, search, sqlDate);
        this.addDateFilter(query, "login", sqlDate);
        if (isLogin) {
            this.addWhereQuery(query, search.getRegime(), "login.login");
        } else {
            this.addWhereQuery(query, search.getRegime(), "alias.login_alias");
        }
        this.addLimitAndTitleRegexpFilter(query, search);
        return this.extractContracts(con, query.toString(), param);
    }
}

