/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.admin.resource.bean.NumberResourceManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionNumberResourceTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int categoryId = this.getIntParameter("category_id", -1);
        Calendar onDate = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("on_date"));
        String status = this.getParameter("status");
        String fromNumber = this.getParameter("from_number");
        String toNumber = this.getParameter("to_number");
        boolean reserved = this.getBooleanParameter("inc_reserved", false);
        if (categoryId < 0 || this.mid <= 0 || Utils.isBlankString((String)status)) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        NumberResourceManager resourceManager = new NumberResourceManager(this.con, this.mid);
        List<NumberResource> resourceList = null;
        resourceList = status.equals("free") ? resourceManager.getFreeNumberList(categoryId, onDate, fromNumber, toNumber, false) : (status.equals("busy") ? resourceManager.getBusyNumberList(categoryId, onDate, fromNumber, toNumber, false) : (status.equals("free_reserve") ? resourceManager.getFreeNumberList(categoryId, onDate, fromNumber, toNumber, true) : (status.equals("busy_reserve") ? resourceManager.getBusyNumberList(categoryId, onDate, fromNumber, toNumber, true) : (status.equals("lastuse") ? resourceManager.getLastUseNumberList(categoryId, new GregorianCalendar(), fromNumber, toNumber, onDate) : (status.equals("reserved") ? resourceManager.getReservedNumberList(categoryId, onDate, fromNumber, toNumber) : resourceManager.getResourceList(categoryId, fromNumber, toNumber))))));
        for (NumberResource resource : resourceList) {
            Element row = this.createElement(data, "row");
            row.setAttribute("period", TimeUtils.formatPeriod((Date)resource.getDateFrom(), (Date)resource.getDateTo()));
            row.setAttribute("number", resource.getNumber());
            row.setAttribute("id", String.valueOf(resource.getId()));
            row.setAttribute("title", resource.getContractTitle());
            row.setAttribute("comment", resource.getContractComment());
            row.setAttribute("dateReserve", TimeUtils.formatDate((Date)resource.getDateReserve()));
            row.setAttribute("reserveComment", resource.getReserveComment());
        }
    }
}

