/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class BGUTableRowSorter<M extends TableModel>
extends TableRowSorter<M> {
    public BGUTableRowSorter(M model) {
        super(model);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            int sortIndex;
            List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(0, sortKey);
            } else if (sortIndex == 0) {
                keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
            } else {
                keys.remove(sortIndex);
                keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
            }
            if (keys.size() > this.getMaxSortKeys()) {
                keys = keys.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(keys);
        }
    }

    protected RowSorter.SortKey toggle(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        if (key.getSortOrder() == SortOrder.DESCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }
}

