/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNoteService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractNoteService")
public class ContractNoteServiceImpl
extends AbstractService
implements ContractNoteService {
    private ContractNoteDao contractNoteDao;

    @PostConstruct
    void init() {
        this.contractNoteDao = new ContractNoteDao(this.getConnection());
    }

    @Override
    public List<ContractNote> contractNoteList(int contractId, boolean customer) throws BGException {
        return this.contractNoteDao.list(contractId, customer);
    }

    @Override
    public void contractNoteDelete(int contractId, int id) throws BGException {
        ContractNote cn = (ContractNote)this.contractNoteDao.get(id);
        if (cn == null || cn.getContractId() != contractId) {
            throw new BGIllegalArgumentException();
        }
        this.contractNoteDao.delete(id);
    }

    @Override
    public int contractNoteUpdate(int contractId, ContractNote contractNote) throws BGException {
        if (contractNote == null) {
            throw new BGIllegalArgumentException("contractNotification");
        }
        if (contractNote.getContractId() <= 0 || contractNote.getContractId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        contractNote.setUserId(this.userId);
        this.contractNoteDao.update(contractNote);
        return contractNote.getId();
    }

    @Override
    public ContractNote getContractNote(int contractNoteId) throws BGException {
        return (ContractNote)this.contractNoteDao.get(contractNoteId);
    }
}

