/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectTypeParamDirectory
extends BGPanel
implements ActionListener {
    private DefaultListModel<ListItem> typeModel = new DefaultListModel();
    private JList<ListItem> typeList = new JList<ListItem>(this.typeModel);
    private BGComboBox<ComboBoxItem> paramSelectComboBox = new BGComboBox();
    private JPanel editor = new JPanel(new GridBagLayout());
    private ObjectTypeParamTableModel tableModel = new ObjectTypeParamTableModel(ObjectTypeParamTableModel.class.getName());

    public ObjectTypeParamDirectory() {
        this.jbInit();
        this.editor.setVisible(false);
    }

    private void jbInit() {
        BGUTable paramTable = new BGUTable(this.tableModel);
        paramTable.setSelectionMode(0);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        JPanel paramViewer = new JPanel(new GridBagLayout());
        paramViewer.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        paramViewer.add((Component)new JScrollPane(paramTable), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        paramViewer.add((Component)this.editor, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSplitPaneNoBorder mainSplit = new BGSplitPaneNoBorder(0, new JScrollPane(this.typeList), (Component)paramViewer, 500L);
        this.editor.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add(this.paramSelectComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 10), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopParamAdd(e.getActionCommand().equals("ok")));
        this.editor.add((Component)okCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.typeList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.showParams();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)mainSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("TypeList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildList(this.typeList, this.typeModel, XMLUtils.selectElement(doc, "//list"));
        }
    }

    private void showParams() {
        ArrayList data = new ArrayList();
        String id = ClientUtils.getIdFromList(this.typeList);
        if (id != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeParamTable");
            request.setAttribute("type", id);
            Document doc = this.getDocument(request);
            XMLUtils.selectElements(doc, "//table/data/row").forEach(row -> {
                ObjectTypeParam objectTypeParam = new ObjectTypeParam();
                objectTypeParam.setParamId(Utils.parseInt(row.getAttribute("param_id")));
                objectTypeParam.setType(row.getAttribute("type"));
                objectTypeParam.setParam(row.getAttribute("param"));
                data.add(objectTypeParam);
            });
        }
        this.tableModel.setData(data);
        this.editor.setVisible(false);
    }

    private void startParamAdd() {
        String id = ClientUtils.getIdFromList(this.typeList);
        if (id != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("FreeTypeParamList");
            request.setAttribute("type", id);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                ClientUtils.buildComboBox(this.paramSelectComboBox, XMLUtils.selectElement(doc, "//list"), "");
            }
            this.editor.setVisible(true);
        }
    }

    private void stopParamAdd(boolean add) {
        if (add) {
            String type = ClientUtils.getIdFromList(this.typeList);
            String paramId = ClientUtils.getIdFromComboBox(this.paramSelectComboBox);
            if (paramId == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440!");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeParamAdd");
            request.setAttribute("type", type);
            request.setAttribute("param", paramId);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.editor.setVisible(false);
                this.showParams();
            }
        } else {
            this.editor.setVisible(false);
        }
    }

    private void deleteParam() {
        String type = ClientUtils.getIdFromList(this.typeList);
        ObjectTypeParam objectTypeParam = (ObjectTypeParam)this.tableModel.getSelectedRow();
        if (type != null && objectTypeParam != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043a \u0442\u0438\u043f\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeParamDelete");
            request.setAttribute("type", type);
            request.setAttribute("param", objectTypeParam.getParamId());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.showParams();
            }
        }
    }

    private void move(boolean up) {
        String type = ClientUtils.getIdFromList(this.typeList);
        ObjectTypeParam objectTypeParam = (ObjectTypeParam)this.tableModel.getSelectedRow();
        if (type != null && objectTypeParam != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("TypeParamMove");
            if (up) {
                request.setAttribute("up", 1);
            }
            request.setAttribute("type", type);
            request.setAttribute("param", objectTypeParam.getParamId());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.showParams();
                List rows = this.tableModel.getRows();
                for (int i = rows.size() - 1; i >= 0; --i) {
                    if (objectTypeParam.getParamId() != ((ObjectTypeParam)rows.get(i)).getParamId()) continue;
                    this.tableModel.setSelectedRow((ObjectTypeParam)rows.get(i));
                    break;
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String command = actionEvent.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.startParamAdd();
            } else if (command.equals("deleteItem")) {
                this.deleteParam();
            } else if (command.equals("upItem")) {
                this.move(true);
            } else if (command.equals("downItem")) {
                this.move(false);
            }
        }
    }

    class ObjectTypeParamTableModel
    extends BGTableModel<ObjectTypeParam> {
        public ObjectTypeParamTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("ID", 80, 80, 80, "paramId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "type", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", -1, -1, -1, "param", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class ObjectTypeParam {
        private int paramId;
        private String type;
        private String param;

        public int getParamId() {
            return this.paramId;
        }

        public void setParamId(int paramId) {
            this.paramId = paramId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String param) {
            this.param = param;
        }
    }
}

