/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.common.bean;

import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public class ProductOfferingActivationMode
implements GuiTitlable {
    private ProductSpecActivationMode productSpecActivationMode;
    private BigDecimal activationPrice;
    private int periodMode;
    private int periodAmount;
    private BigDecimal price;

    public ProductOfferingActivationMode() {
    }

    public ProductOfferingActivationMode(ProductSpecActivationMode productSpecActivationMode, BigDecimal price) {
        this.productSpecActivationMode = productSpecActivationMode;
        this.price = price;
    }

    public ProductSpecActivationMode getProductSpecActivationMode() {
        return this.productSpecActivationMode;
    }

    public void setProductSpecActivationMode(ProductSpecActivationMode productSpecActivationMode) {
        this.productSpecActivationMode = productSpecActivationMode;
    }

    @XmlAttribute
    public BigDecimal getActivationPrice() {
        return this.activationPrice;
    }

    public void setActivationPrice(BigDecimal activationPrice) {
        this.activationPrice = activationPrice;
    }

    @XmlAttribute
    public int getPeriodMode() {
        return this.periodMode;
    }

    public void setPeriodMode(int periodMode) {
        this.periodMode = periodMode;
    }

    @XmlAttribute
    public int getPeriodAmount() {
        return this.periodAmount;
    }

    public void setPeriodAmount(int periodAmount) {
        this.periodAmount = periodAmount;
    }

    @XmlAttribute
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public void setPriceString(String String2) {
    }

    @XmlAttribute
    public String getPriceString() {
        if (this.price == null) {
            return null;
        }
        return Utils.formatCost(this.price) + "/" + this.getPricePeriodString();
    }

    @XmlAttribute
    public String getPricePeriodString() {
        return TimeUtils.formatCount(switch (this.periodMode) {
            case 1 -> 12;
            case 2 -> 10;
            case 3 -> 5;
            case 4 -> 3;
            default -> 2;
        }, this.periodAmount);
    }

    public void setPricePeriodString(String nil) {
    }

    public String toString() {
        if (this.price != null) {
            if (this.activationPrice != null && BigDecimal.ZERO.compareTo(this.activationPrice) != 0) {
                return String.valueOf(this.productSpecActivationMode) + " \u0437\u0430 " + Utils.formatCost(this.activationPrice) + ", " + this.getPriceString();
            }
            return String.valueOf(this.productSpecActivationMode) + " \u0437\u0430 " + this.getPriceString();
        }
        if (this.productSpecActivationMode == null) {
            return "null";
        }
        String result = this.productSpecActivationMode.toString();
        if (result == null || result.length() == 0) {
            return "\u0411\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f (" + this.productSpecActivationMode.getId() + ")";
        }
        return result;
    }

    @Override
    public String getGuiTitle() {
        return this.toString();
    }
}

