/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.common.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.xml.JAXBUtils;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;

public class Product
extends Id
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final short STATE_NULL = -1000;
    public static final short STATE_REMOVED = -1;
    public static final short STATE_DISABLED = 0;
    public static final short STATE_ENABLED = 1;
    private int contractId;
    private int accountId;
    private int productSpecId;
    private String productSpecTitle;
    private Date timeFrom;
    private Date timeTo;
    private int userId;
    private int activationModeId;
    private BigDecimal activationPrice;
    private Date activationTime;
    private Date deactivationTime;
    private volatile String deviceProductId;
    private volatile short deviceState;
    private List<Service> serviceList;
    private String comment;
    private String description;
    private Date subscriptionTimeFrom;
    private Date subscriptionTimeTo;

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    @XmlAttribute
    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public void setProductSpecId(int specId) {
        this.productSpecId = specId;
    }

    public void setProductSpecTitle(String specTitle) {
        this.productSpecTitle = specTitle;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(Date timeFrom) {
        this.timeFrom = timeFrom;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(Date timeTo) {
        this.timeTo = timeTo;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @XmlAttribute
    public int getActivationModeId() {
        return this.activationModeId;
    }

    public void setActivationModeId(int activationMode) {
        this.activationModeId = activationMode;
    }

    @XmlAttribute
    public BigDecimal getActivationPrice() {
        return this.activationPrice;
    }

    public void setActivationPrice(BigDecimal activationCost) {
        this.activationPrice = activationCost;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getDeactivationTime() {
        return this.deactivationTime;
    }

    public void setDeactivationTime(Date deactivationTime) {
        this.deactivationTime = deactivationTime;
    }

    @XmlAttribute
    public int getProductSpecId() {
        return this.productSpecId;
    }

    @XmlAttribute
    public String getProductSpecTitle() {
        return this.productSpecTitle;
    }

    @XmlAttribute(name="devProductId")
    public String getDeviceProductId() {
        return this.deviceProductId;
    }

    public void setDeviceProductId(String deviceProductId) {
        this.deviceProductId = deviceProductId;
    }

    @XmlAttribute(name="devState")
    public short getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(short deviceState) {
        this.deviceState = deviceState;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElementWrapper(name="serviceList")
    @XmlElements(value={@XmlElement(name="service")})
    public List<Service> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(List<Service> serviceList) {
        this.serviceList = serviceList;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getSubscriptionTimeTo() {
        return this.subscriptionTimeTo;
    }

    public void setSubscriptionTimeTo(Date subscriptionTimeTo) {
        this.subscriptionTimeTo = subscriptionTimeTo;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=JAXBUtils.DateTimeAdapter.class)
    public Date getSubscriptionTimeFrom() {
        return this.subscriptionTimeFrom;
    }

    public void setSubscriptionTimeFrom(Date subscriptionTimeFrom) {
        this.subscriptionTimeFrom = subscriptionTimeFrom;
    }

    @Override
    public String toString() {
        return "Product [cid-aid=" + this.contractId + "-" + this.accountId + ", productSpecId=" + this.productSpecId + ", period=" + TimeUtils.format(this.timeFrom, "dd.MM.yyyy HH:mm:ss") + "-" + TimeUtils.format(this.timeTo, "dd.MM.yyyy HH:mm:ss") + "/" + TimeUtils.format(this.subscriptionTimeTo, "dd.MM.yyyy HH:mm:ss") + ", activationModeId=" + this.activationModeId + ", activationTime=" + this.activationTime + ", deactivationTime=" + this.deactivationTime + ", deviceState=" + this.deviceState + ", serviceList=" + this.serviceList + "]";
    }

    public Product clone() {
        try {
            Product result = (Product)super.clone();
            if (result.serviceList != null) {
                int size = result.serviceList.size();
                for (int i = 0; i < size; ++i) {
                    result.serviceList.set(i, result.serviceList.get(i).clone());
                }
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

