/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class JsonAdapters {

    public static class LocalTimeDeserializer
    extends JsonDeserializer<LocalTime> {
        public LocalTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return LocalTime.parse(parser.getText());
        }
    }

    public static class LocalTimeSerializer
    extends JsonSerializer<LocalTime> {
        public void serialize(LocalTime value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(value.toString());
        }
    }

    public static class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return LocalDateTime.parse(parser.getText());
        }
    }

    public static class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        public void serialize(LocalDateTime value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(value.toString());
        }
    }
}

