/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.ContractStockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ContractStockItemDao
extends AbstractIdDao<ContractStockItem> {
    private final StockItemDao stockItemDao;

    public ContractStockItemDao(Connection connection, int moduleId) {
        super(connection, "contract_stock_item", moduleId);
        this.stockItemDao = new StockItemDao(connection, moduleId);
    }

    protected ContractStockItem getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractStockItem entry = new ContractStockItem();
        entry.setId(rs.getInt("id"));
        entry.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date_from")));
        entry.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date_to")));
        entry.setContractId(rs.getInt("contract_id"));
        entry.setStockItem((StockItem)this.stockItemDao.get(rs.getInt("stock_item_id")));
        entry.setUserId(rs.getInt("user_id"));
        return entry;
    }

    protected void updateImpl(ContractStockItem contractStockItem) throws BGException, SQLException {
        boolean isNew = contractStockItem.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET date_from=?, date_to=?, contract_id=?, stock_item_id=?, user_id=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)contractStockItem.getDateFrom()));
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)contractStockItem.getDateTo()));
            ps.setInt(3, contractStockItem.getContractId());
            ps.setInt(4, contractStockItem.getStockItem().getId());
            ps.setInt(5, contractStockItem.getUserId());
            if (!isNew) {
                ps.setInt(6, contractStockItem.getId());
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ContractStockItem> getListByContractId(int contractId, boolean onlyActive) throws BGException {
        ArrayList<ContractStockItem> result = new ArrayList<ContractStockItem>();
        String query = "SELECT * FROM " + this.tableName + " WHERE contract_id=?";
        if (onlyActive) {
            query = query + " AND date_from<? AND (date_to IS NULL OR date_to>?)";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            if (onlyActive) {
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)new Date()));
                ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)new Date()));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException();
        }
        return result;
    }

    public int getContractIdByStockItem(int stockItemId, Date dateFilter) throws BGException {
        int result = -1;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT contract_id FROM " + this.tableName + " WHERE stock_item_id=? AND date_from<=? AND (date_to IS NULL OR date_to>?)");){
            ps.setInt(1, stockItemId);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateFilter));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)dateFilter));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt("contract_id");
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<ContractStockItem> getByStockItemId(int stockItemId) throws BGException {
        String query = "SELECT * FROM " + this.tableName + " WHERE stock_item_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, stockItemId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Optional.empty();
                Optional<ContractStockItem> optional = Optional.of(this.getFromRS(rs));
                return optional;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void list(SearchResult<ContractStockItem> searchResult, int contractId) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE 1=1";
        if (contractId > 0) {
            query = query + " AND contract_id=?";
        }
        if (searchResult.getPeriod() != null) {
            if (searchResult.getPeriod().getDateFrom() != null) {
                query = query + " AND (date_to IS NULL OR date_to>=?)";
            }
            if (searchResult.getPeriod().getDateTo() != null) {
                query = query + " AND date_from<=?";
            }
        }
        query = query + " ORDER BY id DESC";
        query = query + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            if (searchResult.getPeriod() != null) {
                int index = 1;
                if (contractId > 0) {
                    ps.setInt(index++, contractId);
                }
                if (searchResult.getPeriod().getDateFrom() != null) {
                    ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)searchResult.getPeriod().getDateFrom()));
                }
                if (searchResult.getPeriod().getDateTo() != null) {
                    ps.setTimestamp(index, TimeUtils.convertDateToTimestamp((Date)searchResult.getPeriod().getDateTo()));
                }
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

