/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

public class DeviceTreeFilter {
    private String deviceId;
    private String identifier;
    private String host;
    private Set<Integer> deviceTypeIds;
    private Set<Integer> deviceGroupIds;
    private Date dateFrom;
    private Date dateTo;
    private Date intersectDateFrom;
    private Date intersectDateTo;
    private List<FilterEntityAttr> entityFilter;
    private boolean loadDeviceGroupLink;

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public Set<Integer> getDeviceGroupIds() {
        return this.deviceGroupIds;
    }

    @XmlAttribute
    public String getDeviceId() {
        return this.deviceId;
    }

    public Set<Integer> getDeviceTypeIds() {
        return this.deviceTypeIds;
    }

    public List<FilterEntityAttr> getEntityFilter() {
        return this.entityFilter;
    }

    @XmlAttribute
    public String getHost() {
        return this.host;
    }

    @XmlAttribute
    public String getIdentifier() {
        return this.identifier;
    }

    @XmlAttribute
    public Date getIntersectDateFrom() {
        return this.intersectDateFrom;
    }

    @XmlAttribute
    public Date getIntersectDateTo() {
        return this.intersectDateTo;
    }

    @XmlAttribute
    public boolean isLoadDeviceGroupLink() {
        return this.loadDeviceGroupLink;
    }

    public Optional<Date> optDateFrom() {
        return Optional.ofNullable(this.dateFrom);
    }

    public Optional<Date> optDateTo() {
        return Optional.ofNullable(this.dateTo);
    }

    public Optional<Set<Integer>> optDeviceGroupIds() {
        return Optional.ofNullable(this.deviceGroupIds != null && !this.deviceGroupIds.isEmpty() ? this.deviceGroupIds : null);
    }

    public Optional<String> optDeviceId() {
        return Optional.ofNullable(Utils.isBlankString(this.deviceId) ? null : this.deviceId);
    }

    public Optional<Set<Integer>> optDeviceTypeIds() {
        return Optional.ofNullable(this.deviceTypeIds != null && !this.deviceTypeIds.isEmpty() ? this.deviceTypeIds : null);
    }

    public Optional<String> optHost() {
        return Optional.ofNullable(Utils.isBlankString(this.host) ? null : this.host);
    }

    public Optional<String> optIdentifier() {
        return Optional.ofNullable(Utils.isBlankString(this.identifier) ? null : this.identifier);
    }

    public Optional<Date> optIntersectDateFrom() {
        return Optional.ofNullable(this.intersectDateFrom);
    }

    public Optional<Date> optIntersectDateTo() {
        return Optional.ofNullable(this.intersectDateTo);
    }

    public DeviceTreeFilter setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    public DeviceTreeFilter setDateTo(Date dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    public DeviceTreeFilter setDeviceGroupIds(Set<Integer> deviceGroupIds) {
        this.deviceGroupIds = deviceGroupIds;
        return this;
    }

    public DeviceTreeFilter setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public DeviceTreeFilter setDeviceTypeIds(Set<Integer> deviceTypeIds) {
        this.deviceTypeIds = deviceTypeIds;
        return this;
    }

    public DeviceTreeFilter setEntityFilter(List<FilterEntityAttr> entityFilter) {
        this.entityFilter = entityFilter;
        return this;
    }

    public DeviceTreeFilter setHost(String host) {
        this.host = host;
        return this;
    }

    public DeviceTreeFilter setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public DeviceTreeFilter setIntersectDateFrom(Date intersectDateFrom) {
        this.intersectDateFrom = intersectDateFrom;
        return this;
    }

    public DeviceTreeFilter setIntersectDateTo(Date intersectDateTo) {
        this.intersectDateTo = intersectDateTo;
        return this;
    }

    public DeviceTreeFilter setLoadDeviceGroupLink(boolean loadDeviceGroupLink) {
        this.loadDeviceGroupLink = loadDeviceGroupLink;
        return this;
    }
}

