/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.pscb.server.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.pscb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.pscb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.pscb.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="PSCBExecutor", urlPatterns={"/pscbexecuter/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSS";
    private static final String CONFIRM_ACTION = "CONFIRM";
    private static final String REJECT_ACTION = "REJECT";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block40: {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                TransactionManager transactionManager = new TransactionManager(con, moduleId);
                ServletInputStream is = request.getInputStream();
                byte[] requestBytes = Utils.readByBlock((InputStream)is);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("requestBytes = " + String.valueOf(requestBytes));
                    if (requestBytes != null) {
                        this.getLogger().debug("requestBytes.length = " + requestBytes.length);
                        this.getLogger().debug("requestBytes = " + Utils.bytesToHexString((byte[])requestBytes));
                    }
                }
                byte[] decryptedRequest = new byte[requestBytes.length];
                try {
                    byte[] key = MessageDigest.getInstance("MD5").digest(moduleSetup.get("pscb.secret.key", "").getBytes("UTF-8"));
                    SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
                    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    cipher.init(2, secretKey);
                    decryptedRequest = cipher.doFinal(requestBytes);
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    throw new BGException("Some decrypt problems." + e.getMessage(), (Throwable)e);
                }
                String jsonRequestString = new String(decryptedRequest, "UTF-8");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u0412\u0445\u043e\u0434\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043e\u0442 \u041f\u0421\u041a\u0411: " + jsonRequestString);
                }
                if (jsonRequestString == null || jsonRequestString.isEmpty()) {
                    throw new BGException("JsonRequestString is null or empty.");
                }
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode root = mapper.readTree(jsonRequestString);
                    JsonNode paymentsNode = root.path("payments");
                    HashMap answerMap = new HashMap();
                    ArrayList<JsonPaymentAnswer> answerList = new ArrayList<JsonPaymentAnswer>();
                    answerMap.put("payments", answerList);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439, \u043f\u0440\u0438\u0448\u0435\u0434\u0448\u0438\u0445 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435");
                    }
                    for (JsonNode currentPaymentNode : paymentsNode) {
                        String orderId = (String)mapper.convertValue((Object)currentPaymentNode.get("orderId"), String.class);
                        String pscbOrderId = (String)mapper.convertValue((Object)currentPaymentNode.get("paymentId"), String.class);
                        String paymentMethod = (String)mapper.convertValue((Object)currentPaymentNode.get("paymentMethod"), String.class);
                        String state = (String)mapper.convertValue((Object)currentPaymentNode.get("state"), String.class);
                        String stateDate = (String)mapper.convertValue((Object)currentPaymentNode.get("stateDate"), String.class);
                        float amount = ((Float)mapper.convertValue((Object)currentPaymentNode.get("amount"), Float.class)).floatValue();
                        DecimalFormat orderIdFormat = new DecimalFormat(moduleSetup.get("pscb.order.id.format", "BG00000000"));
                        int transactionId = orderIdFormat.parse(orderId).intValue();
                        Transaction transaction = transactionManager.getTransactionById(transactionId);
                        if (transaction == null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e " + orderId);
                            }
                            answerList.add(new JsonPaymentAnswer(this, orderId, REJECT_ACTION));
                            continue;
                        }
                        AbstractTransactionStatus status = TransactionStatus.ALL.getStatusByCode(state);
                        if (!status.getCode().equals(transaction.getStatus())) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438 \u0432 \u0411\u0414");
                            }
                            transaction.setStatus(status.getCode());
                            transaction.setTransactionDate(new SimpleDateFormat(DATE_FORMAT).parse(stateDate));
                            transaction.setTransactionId(pscbOrderId);
                            transaction.setSum(new BigDecimal(amount));
                            transaction.setPaymentMethod(paymentMethod);
                            transactionManager.update(transaction);
                            answerList.add(new JsonPaymentAnswer(this, orderId, CONFIRM_ACTION));
                            boolean paymentDeleted = false;
                            Payment payment = null;
                            PaymentDao paymentDao = new PaymentDao(con);
                            if (status.getCode().equals(TransactionStatus.END.getCode())) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430. \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432 \u0411\u0414");
                                }
                                payment = new Payment().setDate(transaction.getTransactionDate()).setTypeId(moduleSetup.getInt("pscb.payment.type.id", -1)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("pscb.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 PSCB [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                                paymentDao.update((Object)payment);
                                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                            } else if (status.getCode().equals(TransactionStatus.REF.getCode()) && transaction.getPaymentId() > 0) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0438\u043c\u0435\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0451\u043d \u0432 \u041f\u0421 \u0432 \u043f\u043e\u043b\u043d\u043e\u0439 \u0441\u0443\u043c\u043c\u0435. \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438\u0437 \u0411\u0414.");
                                }
                                payment = (Payment)paymentDao.get(transaction.getPaymentId());
                                paymentDao.delete(transaction.getPaymentId());
                                paymentDeleted = true;
                            }
                            if (payment == null) continue;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                            }
                            ServerUtils.commitConnection((Connection)con);
                            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                                balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                            }
                            ServerUtils.commitConnection((Connection)con);
                            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, paymentDeleted ? payment.getSum().negate() : payment.getSum()));
                            continue;
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f \u0441 \u043a\u043e\u0434\u043e\u043c " + orderId + " \u0432 \u0411\u0414 \u0438\u043c\u0435\u0435\u0442 \u0442\u0430\u043a\u043e\u0439 \u0436\u0435 \u0441\u0442\u0430\u0442\u0443\u0441: " + status.getTitle());
                        }
                        answerList.add(new JsonPaymentAnswer(this, orderId, CONFIRM_ACTION));
                    }
                    ServletOutputStream out = response.getOutputStream();
                    mapper.writeValue((OutputStream)out, answerMap);
                    if (!this.getLogger().isDebugEnabled()) break block40;
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                        mapper.writeValue((OutputStream)baos, answerMap);
                        this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u041f\u0421\u041a\u0411 \u0432 \u0432\u0438\u0434\u0435 json: " + baos.toString());
                    }
                }
                catch (IOException | ParseException e) {
                    throw new BGException("\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0438 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u043f\u0440\u0438 \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u043d\u0438\u0438 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u0438\u0437 \u0432\u0445\u043e\u0434\u043d\u044b\u0445 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432.", (Throwable)e);
                }
            }
            catch (Exception ex) {
                this.logError(ex);
                response.sendError(500, ex.getMessage());
                return;
            }
        }
        response.setStatus(200);
    }

    class JsonPaymentAnswer {
        private String orderId;
        private String action;

        public JsonPaymentAnswer(ModuleExecutor this$0, String orderId, String action) {
            this.orderId = orderId;
            this.action = action;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public String getAction() {
            return this.action;
        }
    }
}

